/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo.stat;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import java.util.Iterator;
import java.util.Map;

public class OcpxControlModelBo {
    public static void expire(OcpxControlModel ocpxControlModel, int ttl) {
        if (ocpxControlModel == null) {
            return;
        }
        ttl /= 60;
        Map ocpxControlSubModelMap = ocpxControlModel.getOcpxControlSubModelMap();
        Iterator it1 = ocpxControlSubModelMap.entrySet().iterator();
        while (it1.hasNext()) {
            Map.Entry entry = it1.next();
            Map subMap = (Map)entry.getValue();
            if (subMap != null) {
                Iterator it11 = subMap.entrySet().iterator();
                while (it11.hasNext()) {
                    Map.Entry entry1 = it11.next();
                    OcpxControlSubModel value = (OcpxControlSubModel)entry1.getValue();
                    if (value != null && !OcpxControlModelBo.expireOcpxControlSubModel(value, ttl)) continue;
                    it11.remove();
                }
                if (!subMap.isEmpty()) continue;
                it1.remove();
                continue;
            }
            it1.remove();
        }
        Map adControlParamsMap = ocpxControlModel.getAdControlParamsMap();
        Iterator it2 = adControlParamsMap.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            AdControlParams params = (AdControlParams)entry.getValue();
            if (params != null && !OcpxControlModelBo.expire(params.getUpdateTime(), ttl)) continue;
            it2.remove();
        }
        Map adSlotControlParamsHashMap = ocpxControlModel.getAdSlotControlParamsHashMap();
        Iterator it3 = adSlotControlParamsHashMap.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry entry = it3.next();
            Map subMap = (Map)entry.getValue();
            if (subMap != null) {
                Iterator it31 = subMap.entrySet().iterator();
                while (it31.hasNext()) {
                    Map.Entry entry1 = it31.next();
                    AdControlParams params = (AdControlParams)entry1.getValue();
                    if (params != null && !OcpxControlModelBo.expire(params.getUpdateTime(), ttl)) continue;
                    it31.remove();
                }
                if (!subMap.isEmpty()) continue;
                it3.remove();
                continue;
            }
            it3.remove();
        }
        Map slotControlParamsMap = ocpxControlModel.getSlotControlParamsMap();
        Iterator it4 = slotControlParamsMap.entrySet().iterator();
        while (it4.hasNext()) {
            Map.Entry entry = it4.next();
            SlotControlParams params = (SlotControlParams)entry.getValue();
            if (params != null && !OcpxControlModelBo.expire(params.getUpdateTime(), ttl)) continue;
            it4.remove();
        }
    }

    public static boolean expireOcpxControlSubModel(OcpxControlSubModel ocpxControlSubModel, int ttl) {
        boolean ret = false;
        if (ocpxControlSubModel != null) {
            for (int i = 0; i < 3; ++i) {
                OcpxControlModelBo.expireOcpxControlParamsMap(ocpxControlSubModel.getOcpxControlParamsMap(i), ttl);
            }
            OcpxControlModelBo.expireDeepControlParamsMap(ocpxControlSubModel.getDeepControlParamsMap(), ttl);
            if (OcpxControlModelBo.expire(ocpxControlSubModel.getUpdateTime(), ttl)) {
                ret = true;
            }
        }
        return ret;
    }

    public static void expireOcpxControlParamsMap(Map<Long, OcpxControlParams> map, int ttl) {
        Iterator<Map.Entry<Long, OcpxControlParams>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, OcpxControlParams> entry = it.next();
            OcpxControlParams params = entry.getValue();
            if (params != null && !OcpxControlModelBo.expire(params.getUpdateTime(), ttl)) continue;
            it.remove();
        }
    }

    public static void expireDeepControlParamsMap(Map<Long, DeepControlParams> map, int ttl) {
        Iterator<Map.Entry<Long, DeepControlParams>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, DeepControlParams> entry = it.next();
            DeepControlParams params = entry.getValue();
            if (params != null && !OcpxControlModelBo.expire(params.getUpdateTime(), ttl)) continue;
            it.remove();
        }
    }

    public static boolean expire(String updateTime, int ttl) {
        boolean ret = false;
        if (updateTime != null) {
            Long intervalMins = LocalDateUtil.getIntervalMinutes((String)updateTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            if (intervalMins != null && intervalMins > (long)ttl) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }
}

