/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo.stat;

import cn.com.duiba.nezha.compute.biz.dto.stat.OrderStatSample;
import cn.com.duiba.nezha.compute.biz.dto.stat.PackageInfo;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import org.apache.commons.lang3.StringUtils;

public class StatBaseBo {
    private static String seq = "_";

    public static String getBaseKey(Long ... subKey) {
        return StringUtils.join((Object[])subKey, (String)seq);
    }

    public static boolean resetTimeValid(String time) {
        String currentTime;
        int intervalMinutes;
        return time != null && (intervalMinutes = DateUtil.getDiffMinutes((String)time, (String)(currentTime = DateUtil.getCurrentTime()), (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS).intValue()) >= -10 && intervalMinutes <= 0;
    }

    public static boolean isNewVersion(String v1, String v2, String time1, String time2) {
        if (v1 == null || time1 == null || v2 == null || time2 == null) {
            return true;
        }
        return v1 != v2 && time1.compareTo(time2) < 0;
    }

    public static boolean isSampleNewVersion(String v1, String v2, String time1, String time2) {
        if (v1 == null || time1 == null) {
            return true;
        }
        return v1 != v2 && time1.compareTo(time2) < 0;
    }

    public static void packageInfoUpdate(PackageInfo packageInfo, OrderStatSample sample) {
        Long bidControlType;
        Long cvrType = sample.getBackendType() == null ? null : Long.valueOf((long)sample.getBackendType().intValue() + 0L);
        Long dCvrType = sample.getDepthCvrType() == null ? null : Long.valueOf((long)sample.getDepthCvrType().intValue() + 0L);
        Long releaseTarget = sample.getReleaseTarget() == null ? null : Long.valueOf((long)sample.getReleaseTarget().intValue() + 0L);
        Long deepControlType = sample.getDeepControlType() == null ? null : Long.valueOf((long)sample.getDeepControlType().intValue() + 0L);
        Long l = bidControlType = sample.getBidControlType() == null ? null : Long.valueOf((long)sample.getBidControlType().intValue() + 0L);
        if (sample.isFastTest() || sample.isDeepTest()) {
            packageInfo.setIsTest(true);
        }
        if (sample.getBidControlType() != null) {
            packageInfo.setBidControlType(sample.getBidControlType());
        }
        String version = StatBaseBo.getBaseKey(cvrType, sample.getOldConvertCost(), sample.getDeepFee(), releaseTarget, deepControlType, bidControlType);
        if (StatBaseBo.isSampleNewVersion(packageInfo.getVersion(), version, packageInfo.getUpdateTime(), sample.getTime())) {
            packageInfo.setNewTradeTagId(sample.getNewTradeTagId());
            packageInfo.setAdvertId(sample.getAdvertId());
            packageInfo.setPackageId(sample.getPackageId());
            packageInfo.setOcpcType(sample.isOcpcType());
            packageInfo.setBackendType(cvrType);
            packageInfo.setOldConvertCost(sample.getOldConvertCost());
            packageInfo.setDeepCvrType(dCvrType);
            packageInfo.setDeepFee(sample.getDeepFee());
            packageInfo.setVersion(version);
            packageInfo.setReleaseTarget(releaseTarget);
            packageInfo.setDeepControlType(deepControlType);
            packageInfo.setUpdateTime(sample.getTime());
        }
        if (sample.getReseted() != null) {
            packageInfo.setReseted(sample.getReseted());
            if (sample.getReseted() == 2L && packageInfo.getHasFactorReset() == null) {
                packageInfo.setHasFactorReset(true);
                packageInfo.setUpdateTime(sample.getTime());
            }
        }
    }

    public static void main(String[] arge) {
        System.out.println(StatBaseBo.resetTimeValid("2020-09-23 18:00:00"));
        System.out.println(StatBaseBo.resetTimeValid("2020-09-23 18:30:00"));
        System.out.println(StatBaseBo.resetTimeValid("2020-09-23 19:30:00"));
    }
}

