/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.dto.stat;

import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import cn.com.duiba.nezha.compute.core.util.MathUtil;
import java.util.Arrays;

public class StatBaseDo {
    private long bidCnt;
    private long expCnt;
    private long clickCnt;
    private long[] actCntArray = new long[10];
    private long fees;
    private long fees2;
    private long fees3;
    private long ocpcExpCnt;
    private long ocpcFees;
    private long ocpcFees2;
    private long ocpcFees3;
    private long ocpcFloorFees;
    private long ocpcFloorFees2;
    private long ocpcFloorFees3;
    private double ocpcFactorSum;
    private double secondFactorSum;
    private double deepFactorSum;
    private long dcvrBidCnt;
    private double dcvrSum;
    private double dcvrSquareSum;
    private double[] cvrSumArray = new double[10];
    private double[] cvrSquareSumArray = new double[10];

    public void addBidCnt(long bidCnt) {
        this.bidCnt += bidCnt;
    }

    public void addExpCnt(long expCnt) {
        this.expCnt += expCnt;
    }

    public void addClickCnt(long clickCnt) {
        this.clickCnt += clickCnt;
    }

    public void addFees(long fees) {
        this.fees += fees;
    }

    public void addFees2(long fees) {
        this.fees2 += fees;
    }

    public void addFees3(long fees) {
        this.fees3 += fees;
    }

    public void addActCntArray(long actCnt, int index) {
        int n = index;
        this.actCntArray[n] = this.actCntArray[n] + actCnt;
    }

    public void addActCntArray(long[] actCntArray) {
        for (int i = 0; i < 10; ++i) {
            int n = i;
            this.actCntArray[n] = this.actCntArray[n] + actCntArray[i];
        }
    }

    public void addOcpcExpCnt(double ocpcExpCnt) {
        this.ocpcExpCnt = (long)((double)this.ocpcExpCnt + ocpcExpCnt);
    }

    public void addOcpcFees(long fees) {
        this.ocpcFees += fees;
    }

    public void addOcpcFees2(long fees) {
        this.ocpcFees2 += fees;
    }

    public void addOcpcFees3(long fees) {
        this.ocpcFees3 += fees;
    }

    public void addOcpcFactorSum(double factorSum) {
        this.ocpcFactorSum += factorSum;
    }

    public void addDeepFactorSum(double factorSum) {
        this.deepFactorSum += factorSum;
    }

    public void addOcpcFloorFees(long fees) {
        this.ocpcFloorFees += fees;
    }

    public void addOcpcFloorFees2(long fees) {
        this.ocpcFloorFees2 += fees;
    }

    public void addOcpcFloorFees3(long fees) {
        this.ocpcFloorFees3 += fees;
    }

    public void addDcvrBidCnt(long bidCnt) {
        this.dcvrBidCnt += bidCnt;
    }

    public void addDcvrSum(double dcvrSum) {
        this.dcvrSum += dcvrSum;
    }

    public void addDcvrSquareSum(double dcvrSquareSum) {
        this.dcvrSquareSum += dcvrSquareSum;
    }

    public void addCvrSumArray(double cvrSum, int index) {
        int n = index;
        this.cvrSumArray[n] = this.cvrSumArray[n] + cvrSum;
    }

    public void addCvrSumArray(double[] cvrSumArray) {
        for (int i = 0; i < 10; ++i) {
            int n = i;
            this.cvrSumArray[n] = this.cvrSumArray[n] + cvrSumArray[i];
        }
    }

    public void addCvrSquareSumArray(double cvrSquareSum, int index) {
        int n = index;
        this.cvrSquareSumArray[n] = this.cvrSquareSumArray[n] + cvrSquareSum;
    }

    public void addCvrSquareSumArray(double[] cvrSquareSumArray) {
        for (int i = 0; i < 10; ++i) {
            int n = i;
            this.cvrSquareSumArray[n] = this.cvrSquareSumArray[n] + cvrSquareSumArray[i];
        }
    }

    public void addSecondFactorSum(double factorSum) {
        this.secondFactorSum += factorSum;
    }

    public static Long getAvgFee(StatBaseDo statBaseDo) {
        Long ret = null;
        if (statBaseDo != null && statBaseDo.clickCnt >= 50L) {
            ret = statBaseDo.fees / statBaseDo.clickCnt;
        }
        return ret;
    }

    public static Double getPCvrBias(StatBaseDo statBaseDo, int cvrType, Double defaultValue) {
        Double ret = StatBaseDo.getPCvrBias(statBaseDo, cvrType);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static Double getPCvrBias(StatBaseDo statBaseDo, int cvrType) {
        Double ret = null;
        if (statBaseDo != null) {
            long cvrCnt = statBaseDo.actCntArray[cvrType];
            double pCvrSum = statBaseDo.cvrSumArray[cvrType];
            ret = DataUtil.division((Double)(pCvrSum - (double)cvrCnt), (Long)(cvrCnt + 5L), (int)3);
        }
        return ret;
    }

    public static Double getCFactorAvg(StatBaseDo statBaseDo) {
        Double ret = 1.0;
        if (statBaseDo != null && statBaseDo.ocpcExpCnt > 10L) {
            ret = statBaseDo.getSecondFactorSum() / (double)statBaseDo.getOcpcExpCnt();
        }
        return ret;
    }

    public static Double getPcFactorAvg(StatBaseDo statBaseDo) {
        Double ret = 1.0;
        if (statBaseDo != null && statBaseDo.ocpcExpCnt > 10L) {
            ret = statBaseDo.getOcpcFactorSum() / (double)statBaseDo.getOcpcExpCnt();
        }
        return ret;
    }

    public static Double getCostBias(StatBaseDo statBaseDo, long aFee, Double defaultValue) {
        Double ret = StatBaseDo.getCostBias(statBaseDo, aFee);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static Double getFastCostBias(StatBaseDo statBaseDo, long fastAFee, double fastTarget, int dimType, Double defaultValue) {
        Double ret = StatBaseDo.getFastCostBias(statBaseDo, fastAFee, fastTarget, dimType);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static long getCostDiff(StatBaseDo statBaseDo) {
        return statBaseDo.ocpcFees - statBaseDo.ocpcFees2;
    }

    public static Double getCostBias(StatBaseDo statBaseDo, long aFee) {
        Double ret = null;
        if (statBaseDo != null) {
            double weightDeep = MathUtil.stdwithBoundary((double)(((double)statBaseDo.ocpcFees - 20000.0) / 200000.0), (double)0.0, (double)1.0);
            long feeDiff1 = statBaseDo.ocpcFees - statBaseDo.ocpcFees2;
            long feeDiff2 = statBaseDo.ocpcFees - statBaseDo.ocpcFees3;
            double feeDiff = (1.0 - weightDeep) * (double)feeDiff1 + weightDeep * (double)feeDiff2;
            ret = DataUtil.division((Double)feeDiff, (Long)(statBaseDo.ocpcFees2 + 1000L), (int)3);
            ret = StatBaseDo.isCostConfidence(statBaseDo, aFee) ? Double.valueOf(MathUtil.stdwithBoundary((double)ret, (double)-0.5, (double)0.5)) : (StatBaseDo.isCostDiffConfidence(statBaseDo, aFee) ? Double.valueOf(MathUtil.stdwithBoundary((double)ret, (double)-0.2, (double)0.2)) : Double.valueOf(MathUtil.stdwithBoundary((double)ret, (double)-0.1, (double)0.0)));
        }
        return ret;
    }

    public static Double getFastCostBias(StatBaseDo statBaseDo, long fastAFee, double fastTarget, int dimType) {
        Double ret = null;
        if (statBaseDo != null) {
            double weightDeep = MathUtil.stdwithBoundary((double)(((double)statBaseDo.ocpcFees - 20000.0) / 200000.0), (double)0.0, (double)1.0);
            long ocpcFees2 = DataUtil.double2Long((Double)((double)statBaseDo.ocpcFees2 * (1.0 + fastTarget)));
            long ocpcFees3 = DataUtil.double2Long((Double)((double)statBaseDo.ocpcFees3 * (1.0 + fastTarget)));
            long feeDiff1 = statBaseDo.ocpcFees - ocpcFees2;
            long feeDiff2 = statBaseDo.ocpcFees - ocpcFees3;
            double feeDiff = (1.0 - weightDeep) * (double)feeDiff1 + weightDeep * (double)feeDiff2;
            ret = DataUtil.division((Double)feeDiff, (Long)(ocpcFees2 + 1000L), (int)3);
            ret = StatBaseDo.isCostConfidence2(statBaseDo, fastAFee, dimType) ? Double.valueOf(MathUtil.stdwithBoundary((double)ret, (double)-0.5, (double)0.5)) : (StatBaseDo.isCostDiffConfidence2(statBaseDo, fastAFee, dimType) ? Double.valueOf(MathUtil.stdwithBoundary((double)ret, (double)-0.2, (double)0.2)) : Double.valueOf(MathUtil.stdwithBoundary((double)ret, (double)-0.1, (double)0.1)));
        }
        return ret;
    }

    public static Double getBidRatio(StatBaseDo statBaseDo) {
        Double ret = null;
        if (statBaseDo != null && statBaseDo.bidCnt > 1000L) {
            ret = DataUtil.division((Long)statBaseDo.expCnt, (Long)statBaseDo.bidCnt, (int)3);
            ret = Math.min(ret, 0.9);
        }
        return ret;
    }

    public static long getConvertCnt(long cost, long aFee) {
        return cost / aFee;
    }

    public static boolean isCostConfidence(StatBaseDo statBaseDo, long aFee, int ocpcFeesTh1, int ocpcFeesTh2, int convertCntTh1) {
        boolean ret = false;
        if (statBaseDo != null && statBaseDo.clickCnt >= 10L) {
            long convertCnt;
            if (statBaseDo.ocpcFees >= (long)ocpcFeesTh1) {
                return true;
            }
            if (statBaseDo.ocpcFees >= (long)ocpcFeesTh2 && (convertCnt = StatBaseDo.getConvertCnt(statBaseDo.ocpcFees, aFee)) >= (long)convertCntTh1) {
                return true;
            }
        }
        return ret;
    }

    public static boolean isCostConfidence(StatBaseDo statBaseDo, long aFee) {
        boolean ret = false;
        if (statBaseDo != null && statBaseDo.clickCnt >= 10L) {
            long convertCnt;
            if (statBaseDo.ocpcFees >= 20000L) {
                return true;
            }
            if (statBaseDo.ocpcFees >= 10000L && (convertCnt = StatBaseDo.getConvertCnt(statBaseDo.ocpcFees, aFee)) >= 10L) {
                return true;
            }
        }
        return ret;
    }

    public static boolean isCostConfidence(StatBaseDo statBaseDo, long aFee, int dimType) {
        boolean ret = false;
        if (dimType == 1) {
            return StatBaseDo.isCostConfidence(statBaseDo, aFee, 20000, 10000, 10);
        }
        return StatBaseDo.isCostConfidence(statBaseDo, aFee, 20000, 5000, 10);
    }

    public static boolean isCostConfidence2(StatBaseDo statBaseDo, long aFee, int dimType) {
        boolean ret = false;
        if (dimType == 1) {
            return StatBaseDo.isCostConfidence(statBaseDo, aFee, 10000, 5000, 10);
        }
        return StatBaseDo.isCostConfidence(statBaseDo, aFee, 10000, 5000, 10);
    }

    public static boolean isCostDiffConfidence(StatBaseDo statBaseDo, long aFee, int ocpcFeesTh1, int ocpcFeesTh2, int convertCntTh1) {
        boolean ret = false;
        if (statBaseDo != null && statBaseDo.clickCnt >= 1L) {
            long convertCnt;
            long feeDiff = Math.abs(statBaseDo.ocpcFees - statBaseDo.ocpcFees2);
            if (feeDiff >= (long)ocpcFeesTh1) {
                return true;
            }
            if (feeDiff >= (long)ocpcFeesTh2 && (convertCnt = StatBaseDo.getConvertCnt(feeDiff, aFee)) >= (long)convertCntTh1) {
                return true;
            }
        }
        return ret;
    }

    public static boolean isCostDiffConfidence(StatBaseDo statBaseDo, long aFee, int dimType) {
        boolean ret = false;
        if (dimType == 1) {
            return StatBaseDo.isCostDiffConfidence(statBaseDo, aFee, 5000, 2000, 3);
        }
        return StatBaseDo.isCostDiffConfidence(statBaseDo, aFee, 5000, 2000, 3);
    }

    public static boolean isCostDiffConfidence(StatBaseDo statBaseDo, long aFee) {
        boolean ret = false;
        if (statBaseDo != null && statBaseDo.clickCnt >= 1L) {
            long convertCnt;
            long feeDiff = Math.abs(statBaseDo.ocpcFees - statBaseDo.ocpcFees2);
            if (feeDiff >= 10000L) {
                return true;
            }
            if (feeDiff >= 5000L && (convertCnt = StatBaseDo.getConvertCnt(feeDiff, aFee)) >= 3L) {
                return true;
            }
        }
        return ret;
    }

    public static boolean isCostDiffConfidence2(StatBaseDo statBaseDo, long aFee, int dimType) {
        boolean ret = false;
        if (AssertUtil.isNotEmpty((Object)dimType) && dimType == 1) {
            return StatBaseDo.isCostDiffConfidence(statBaseDo, aFee, 5000, 3000, 3);
        }
        return StatBaseDo.isCostDiffConfidence(statBaseDo, aFee, 5000, 3000, 3);
    }

    public static Long getFloorPriceThreDiff(StatBaseDo statBaseDo, long aFee) {
        Long signal = 0L;
        if (statBaseDo != null) {
            Double floorBias = DataUtil.division((Long)(statBaseDo.ocpcFloorFees - statBaseDo.ocpcFloorFees2), (Long)statBaseDo.ocpcFees, (int)5);
            Double bias = StatBaseDo.getCostBias(statBaseDo, aFee);
            if (floorBias == null) {
                return signal;
            }
            signal = bias < -0.01 ? Long.valueOf(-1L) : (floorBias > 0.01 ? Long.valueOf(Math.random() > 0.5 ? 0L : 1L) : Long.valueOf(Math.random() > 0.5 ? 0L : -1L));
        }
        return signal;
    }

    public static Double getDcvr(StatBaseDo statBaseDo, int startType, int deepType, Double base) {
        Double ret = null;
        if (statBaseDo != null) {
            ret = StatBaseDo.getRatio(statBaseDo.actCntArray[deepType], statBaseDo.actCntArray[startType], base);
        }
        return ret;
    }

    public static Double getCtr(StatBaseDo statBaseDo, Double base) {
        Double ret = null;
        if (statBaseDo != null) {
            ret = StatBaseDo.getRatio(statBaseDo.clickCnt, statBaseDo.expCnt, base);
        }
        return ret;
    }

    public static Double getCvr(StatBaseDo statBaseDo, int startType, Double base) {
        Double ret = null;
        if (statBaseDo != null) {
            ret = StatBaseDo.getRatio(statBaseDo.actCntArray[startType], statBaseDo.clickCnt, base);
        }
        return ret;
    }

    public static Double getRatio(long v1, long v2, Double base) {
        Double ret = null;
        if (base != null) {
            ret = DataUtil.division((Double)(base * 60.0 + (double)v1), (Long)(60L + v2), (int)4);
        } else if (v2 >= 50L) {
            ret = DataUtil.division((Long)v1, (Long)v2, (int)4);
        }
        return ret;
    }

    public long getBidCnt() {
        return this.bidCnt;
    }

    public long getExpCnt() {
        return this.expCnt;
    }

    public long getClickCnt() {
        return this.clickCnt;
    }

    public long[] getActCntArray() {
        return this.actCntArray;
    }

    public long getFees() {
        return this.fees;
    }

    public long getFees2() {
        return this.fees2;
    }

    public long getFees3() {
        return this.fees3;
    }

    public long getOcpcExpCnt() {
        return this.ocpcExpCnt;
    }

    public long getOcpcFees() {
        return this.ocpcFees;
    }

    public long getOcpcFees2() {
        return this.ocpcFees2;
    }

    public long getOcpcFees3() {
        return this.ocpcFees3;
    }

    public long getOcpcFloorFees() {
        return this.ocpcFloorFees;
    }

    public long getOcpcFloorFees2() {
        return this.ocpcFloorFees2;
    }

    public long getOcpcFloorFees3() {
        return this.ocpcFloorFees3;
    }

    public double getOcpcFactorSum() {
        return this.ocpcFactorSum;
    }

    public double getSecondFactorSum() {
        return this.secondFactorSum;
    }

    public double getDeepFactorSum() {
        return this.deepFactorSum;
    }

    public long getDcvrBidCnt() {
        return this.dcvrBidCnt;
    }

    public double getDcvrSum() {
        return this.dcvrSum;
    }

    public double getDcvrSquareSum() {
        return this.dcvrSquareSum;
    }

    public double[] getCvrSumArray() {
        return this.cvrSumArray;
    }

    public double[] getCvrSquareSumArray() {
        return this.cvrSquareSumArray;
    }

    public void setBidCnt(long bidCnt) {
        this.bidCnt = bidCnt;
    }

    public void setExpCnt(long expCnt) {
        this.expCnt = expCnt;
    }

    public void setClickCnt(long clickCnt) {
        this.clickCnt = clickCnt;
    }

    public void setActCntArray(long[] actCntArray) {
        this.actCntArray = actCntArray;
    }

    public void setFees(long fees) {
        this.fees = fees;
    }

    public void setFees2(long fees2) {
        this.fees2 = fees2;
    }

    public void setFees3(long fees3) {
        this.fees3 = fees3;
    }

    public void setOcpcExpCnt(long ocpcExpCnt) {
        this.ocpcExpCnt = ocpcExpCnt;
    }

    public void setOcpcFees(long ocpcFees) {
        this.ocpcFees = ocpcFees;
    }

    public void setOcpcFees2(long ocpcFees2) {
        this.ocpcFees2 = ocpcFees2;
    }

    public void setOcpcFees3(long ocpcFees3) {
        this.ocpcFees3 = ocpcFees3;
    }

    public void setOcpcFloorFees(long ocpcFloorFees) {
        this.ocpcFloorFees = ocpcFloorFees;
    }

    public void setOcpcFloorFees2(long ocpcFloorFees2) {
        this.ocpcFloorFees2 = ocpcFloorFees2;
    }

    public void setOcpcFloorFees3(long ocpcFloorFees3) {
        this.ocpcFloorFees3 = ocpcFloorFees3;
    }

    public void setOcpcFactorSum(double ocpcFactorSum) {
        this.ocpcFactorSum = ocpcFactorSum;
    }

    public void setSecondFactorSum(double secondFactorSum) {
        this.secondFactorSum = secondFactorSum;
    }

    public void setDeepFactorSum(double deepFactorSum) {
        this.deepFactorSum = deepFactorSum;
    }

    public void setDcvrBidCnt(long dcvrBidCnt) {
        this.dcvrBidCnt = dcvrBidCnt;
    }

    public void setDcvrSum(double dcvrSum) {
        this.dcvrSum = dcvrSum;
    }

    public void setDcvrSquareSum(double dcvrSquareSum) {
        this.dcvrSquareSum = dcvrSquareSum;
    }

    public void setCvrSumArray(double[] cvrSumArray) {
        this.cvrSumArray = cvrSumArray;
    }

    public void setCvrSquareSumArray(double[] cvrSquareSumArray) {
        this.cvrSquareSumArray = cvrSquareSumArray;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatBaseDo)) {
            return false;
        }
        StatBaseDo other = (StatBaseDo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBidCnt() != other.getBidCnt()) {
            return false;
        }
        if (this.getExpCnt() != other.getExpCnt()) {
            return false;
        }
        if (this.getClickCnt() != other.getClickCnt()) {
            return false;
        }
        if (!Arrays.equals(this.getActCntArray(), other.getActCntArray())) {
            return false;
        }
        if (this.getFees() != other.getFees()) {
            return false;
        }
        if (this.getFees2() != other.getFees2()) {
            return false;
        }
        if (this.getFees3() != other.getFees3()) {
            return false;
        }
        if (this.getOcpcExpCnt() != other.getOcpcExpCnt()) {
            return false;
        }
        if (this.getOcpcFees() != other.getOcpcFees()) {
            return false;
        }
        if (this.getOcpcFees2() != other.getOcpcFees2()) {
            return false;
        }
        if (this.getOcpcFees3() != other.getOcpcFees3()) {
            return false;
        }
        if (this.getOcpcFloorFees() != other.getOcpcFloorFees()) {
            return false;
        }
        if (this.getOcpcFloorFees2() != other.getOcpcFloorFees2()) {
            return false;
        }
        if (this.getOcpcFloorFees3() != other.getOcpcFloorFees3()) {
            return false;
        }
        if (Double.compare(this.getOcpcFactorSum(), other.getOcpcFactorSum()) != 0) {
            return false;
        }
        if (Double.compare(this.getSecondFactorSum(), other.getSecondFactorSum()) != 0) {
            return false;
        }
        if (Double.compare(this.getDeepFactorSum(), other.getDeepFactorSum()) != 0) {
            return false;
        }
        if (this.getDcvrBidCnt() != other.getDcvrBidCnt()) {
            return false;
        }
        if (Double.compare(this.getDcvrSum(), other.getDcvrSum()) != 0) {
            return false;
        }
        if (Double.compare(this.getDcvrSquareSum(), other.getDcvrSquareSum()) != 0) {
            return false;
        }
        if (!Arrays.equals(this.getCvrSumArray(), other.getCvrSumArray())) {
            return false;
        }
        return Arrays.equals(this.getCvrSquareSumArray(), other.getCvrSquareSumArray());
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatBaseDo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $bidCnt = this.getBidCnt();
        result = result * 59 + (int)($bidCnt >>> 32 ^ $bidCnt);
        long $expCnt = this.getExpCnt();
        result = result * 59 + (int)($expCnt >>> 32 ^ $expCnt);
        long $clickCnt = this.getClickCnt();
        result = result * 59 + (int)($clickCnt >>> 32 ^ $clickCnt);
        result = result * 59 + Arrays.hashCode(this.getActCntArray());
        long $fees = this.getFees();
        result = result * 59 + (int)($fees >>> 32 ^ $fees);
        long $fees2 = this.getFees2();
        result = result * 59 + (int)($fees2 >>> 32 ^ $fees2);
        long $fees3 = this.getFees3();
        result = result * 59 + (int)($fees3 >>> 32 ^ $fees3);
        long $ocpcExpCnt = this.getOcpcExpCnt();
        result = result * 59 + (int)($ocpcExpCnt >>> 32 ^ $ocpcExpCnt);
        long $ocpcFees = this.getOcpcFees();
        result = result * 59 + (int)($ocpcFees >>> 32 ^ $ocpcFees);
        long $ocpcFees2 = this.getOcpcFees2();
        result = result * 59 + (int)($ocpcFees2 >>> 32 ^ $ocpcFees2);
        long $ocpcFees3 = this.getOcpcFees3();
        result = result * 59 + (int)($ocpcFees3 >>> 32 ^ $ocpcFees3);
        long $ocpcFloorFees = this.getOcpcFloorFees();
        result = result * 59 + (int)($ocpcFloorFees >>> 32 ^ $ocpcFloorFees);
        long $ocpcFloorFees2 = this.getOcpcFloorFees2();
        result = result * 59 + (int)($ocpcFloorFees2 >>> 32 ^ $ocpcFloorFees2);
        long $ocpcFloorFees3 = this.getOcpcFloorFees3();
        result = result * 59 + (int)($ocpcFloorFees3 >>> 32 ^ $ocpcFloorFees3);
        long $ocpcFactorSum = Double.doubleToLongBits(this.getOcpcFactorSum());
        result = result * 59 + (int)($ocpcFactorSum >>> 32 ^ $ocpcFactorSum);
        long $secondFactorSum = Double.doubleToLongBits(this.getSecondFactorSum());
        result = result * 59 + (int)($secondFactorSum >>> 32 ^ $secondFactorSum);
        long $deepFactorSum = Double.doubleToLongBits(this.getDeepFactorSum());
        result = result * 59 + (int)($deepFactorSum >>> 32 ^ $deepFactorSum);
        long $dcvrBidCnt = this.getDcvrBidCnt();
        result = result * 59 + (int)($dcvrBidCnt >>> 32 ^ $dcvrBidCnt);
        long $dcvrSum = Double.doubleToLongBits(this.getDcvrSum());
        result = result * 59 + (int)($dcvrSum >>> 32 ^ $dcvrSum);
        long $dcvrSquareSum = Double.doubleToLongBits(this.getDcvrSquareSum());
        result = result * 59 + (int)($dcvrSquareSum >>> 32 ^ $dcvrSquareSum);
        result = result * 59 + Arrays.hashCode(this.getCvrSumArray());
        result = result * 59 + Arrays.hashCode(this.getCvrSquareSumArray());
        return result;
    }

    public String toString() {
        return "StatBaseDo(bidCnt=" + this.getBidCnt() + ", expCnt=" + this.getExpCnt() + ", clickCnt=" + this.getClickCnt() + ", actCntArray=" + Arrays.toString(this.getActCntArray()) + ", fees=" + this.getFees() + ", fees2=" + this.getFees2() + ", fees3=" + this.getFees3() + ", ocpcExpCnt=" + this.getOcpcExpCnt() + ", ocpcFees=" + this.getOcpcFees() + ", ocpcFees2=" + this.getOcpcFees2() + ", ocpcFees3=" + this.getOcpcFees3() + ", ocpcFloorFees=" + this.getOcpcFloorFees() + ", ocpcFloorFees2=" + this.getOcpcFloorFees2() + ", ocpcFloorFees3=" + this.getOcpcFloorFees3() + ", ocpcFactorSum=" + this.getOcpcFactorSum() + ", secondFactorSum=" + this.getSecondFactorSum() + ", deepFactorSum=" + this.getDeepFactorSum() + ", dcvrBidCnt=" + this.getDcvrBidCnt() + ", dcvrSum=" + this.getDcvrSum() + ", dcvrSquareSum=" + this.getDcvrSquareSum() + ", cvrSumArray=" + Arrays.toString(this.getCvrSumArray()) + ", cvrSquareSumArray=" + Arrays.toString(this.getCvrSquareSumArray()) + ")";
    }
}

