/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.ocpx.control;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.compute.biz.dto.stat.PackageInfo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatBaseDo;
import cn.com.duiba.nezha.compute.biz.ocpx.control.PID;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import cn.com.duiba.nezha.compute.core.util.MathUtil;
import java.util.Arrays;
import java.util.List;

public class OcpxModelBaseBo {
    private static List<Long> dayAdList = Arrays.asList(72260L, 70386L, 72186L, 72214L);

    public static void runStat(StatBaseDo statBaseDo, AdControlParams controlParams) {
        if (statBaseDo != null) {
            controlParams.setCtr(StatBaseDo.getCtr(statBaseDo, null));
            controlParams.setCvr0(StatBaseDo.getCvr(statBaseDo, 0, null));
            controlParams.setCvr2(StatBaseDo.getCvr(statBaseDo, 2, null));
            controlParams.setCvr3(StatBaseDo.getCvr(statBaseDo, 3, null));
        }
    }

    public static void getColdStart(StatBaseDo adAndSlotStatBaseDo, StatBaseDo slotStatBaseDo, AdControlParams adAndSlotControlParams, SlotControlParams slotControlParams) {
        adAndSlotControlParams.setIsColdStart(Boolean.valueOf(false));
        if (adAndSlotStatBaseDo != null && adAndSlotStatBaseDo.getClickCnt() <= 100L) {
            adAndSlotControlParams.setIsColdStart(Boolean.valueOf(true));
        }
        if (slotStatBaseDo != null) {
            slotControlParams.setAvgFee(StatBaseDo.getAvgFee(slotStatBaseDo));
        }
    }

    public static void getPidFactor(PID pid, StatBaseDo statBaseDoHour, StatBaseDo statBaseDoDay, int dimType, OcpxControlParams pidParams, OcpxControlParams baseParams, PackageInfo adPackageInfo) {
        if (adPackageInfo == null) {
            return;
        }
        if (dayAdList.contains(adPackageInfo.getAdvertId())) {
            OcpxModelBaseBo.updatePidFactor(pid, statBaseDoHour, statBaseDoDay, 2, dimType, pidParams, baseParams, adPackageInfo);
        } else {
            OcpxModelBaseBo.updatePidFactor(pid, statBaseDoHour, statBaseDoDay, 1, dimType, pidParams, baseParams, adPackageInfo);
        }
    }

    public static void updatePidFactor(PID pid, StatBaseDo statBaseDoHour, StatBaseDo statBaseDoDay, int taskType, int dimType, OcpxControlParams pidParams, OcpxControlParams baseParams, PackageInfo adPackageInfo) {
        if (adPackageInfo == null) {
            return;
        }
        if (!(pidParams.getCFactor() != null && pidParams.getCConf().booleanValue() || baseParams == null)) {
            pidParams.setCFactor(baseParams.getCFactor());
        }
        Double factor = pidParams.getCFactor() == null ? 1.0 : pidParams.getCFactor();
        Double pcFactor = pidParams.getPcFactor() == null ? 1.0 : pidParams.getPcFactor();
        if (adPackageInfo.getReseted() != null && adPackageInfo.getReseted().equals(2L)) {
            factor = 1.0;
            pcFactor = 1.0;
        }
        long aFee = adPackageInfo.getOldConvertCost();
        if (statBaseDoHour == null) {
            statBaseDoHour = new StatBaseDo();
        }
        if (!StatBaseDo.isCostConfidence(statBaseDoDay, aFee) && !StatBaseDo.isCostDiffConfidence(statBaseDoDay, aFee) || statBaseDoHour.getOcpcExpCnt() < 20L && statBaseDoHour.getBidCnt() < 100L) {
            factor = factor + (1.0 - factor) * 0.1;
            pcFactor = pcFactor + (1.0 - pcFactor) * 0.1;
            pidParams.setCConf(Boolean.valueOf(false));
            pidParams.setCFactor(DataUtil.formatDouble((Double)factor, (int)4));
            pidParams.setPcFactor(DataUtil.formatDouble((Double)pcFactor, (int)4));
            return;
        }
        Double target = 0.001;
        Double costBias = StatBaseDo.getCostBias(statBaseDoHour, aFee, 0.0);
        Double pCvrBias = StatBaseDo.getPCvrBias(statBaseDoHour, adPackageInfo.getBackendType().intValue(), 0.0);
        long ocpcFees = statBaseDoHour.getOcpcFees();
        double confidenceWeight = Math.min(((double)ocpcFees + 0.0) / 15000.0, 1.0);
        Double costBiasDay = StatBaseDo.getCostBias(statBaseDoDay, aFee, 0.0);
        Double pCvrBiasDay = StatBaseDo.getPCvrBias(statBaseDoDay, adPackageInfo.getBackendType().intValue(), 0.0);
        long ocpcFeesDay = statBaseDoDay.getOcpcFees();
        double confidenceWeightDay = Math.min(((double)ocpcFeesDay + 0.0) / 20000.0, 1.0);
        double pcvrBiasMerge = 0.0;
        if (taskType == 1) {
            pcvrBiasMerge = confidenceWeightDay * (1.0 * confidenceWeight * pCvrBias + 1.0 * confidenceWeightDay * pCvrBiasDay) / (1.0 * confidenceWeight + 1.0 * confidenceWeightDay + 0.01);
        }
        if (taskType == 2) {
            pcvrBiasMerge = confidenceWeightDay * pCvrBiasDay;
        }
        Double pcFactorNew = 1.0 / (1.0 + pcvrBiasMerge * 0.9);
        pcFactor = 0.2 + 0.2 * pcFactor + 0.6 * pcFactorNew;
        pcFactor = MathUtil.stdwithBoundary((double)pcFactor, (double)0.25, (double)3.0);
        if (costBiasDay > 0.05 && pcFactor > 0.85) {
            pcFactor = pcFactor - Math.min(costBiasDay - 0.05, pcFactor - 0.85);
        }
        if (costBiasDay > 0.1) {
            pcFactor = Math.min(pcFactor, 1.0);
        }
        if (costBiasDay < -0.05) {
            pcFactor = pcFactor + Math.min(-costBiasDay.doubleValue() - 0.05, 0.1);
        }
        if (costBiasDay < -0.1) {
            pcFactor = Math.max(pcFactor, 1.0);
        }
        double factorAvg = StatBaseDo.getCFactorAvg(statBaseDoHour);
        double signal = 0.0;
        double signal2 = 0.0;
        if (taskType == 1) {
            signal = pid.update(target, costBias, costBiasDay, factor, 0.5);
            signal2 = pid.update(target, costBias, costBiasDay, factor, 0.5);
        }
        if (taskType == 2) {
            signal = pid.update(target, costBiasDay, factor, 0.5);
            signal2 = pid.update(target, costBiasDay, factor, 0.5);
        }
        factor = 0.01 + 0.99 * factor + signal;
        double factor2 = 0.01 + 0.99 * factorAvg + signal2;
        factor = 0.8 * factor + 0.2 * factor2;
        if (costBiasDay < 0.0) {
            factor = Math.max(factor, 0.8);
        }
        if (costBiasDay > 0.0) {
            factor = Math.min(factor, 1.0);
        }
        factor = MathUtil.stdwithBoundary((double)factor, (double)0.45, (double)1.4);
        pidParams.setCConf(Boolean.valueOf(true));
        pidParams.setCFactor(DataUtil.formatDouble((Double)factor, (int)3));
        pidParams.setPcFactor(DataUtil.formatDouble((Double)pcFactor, (int)3));
    }

    public static void getFloorPriceParams(StatBaseDo statBaseDo, OcpxControlParams priceProtectParams, Long aFee) {
        Long floorPrice = 12L;
        Long floorPriceThreshold = priceProtectParams.getFPriceThre();
        if (floorPriceThreshold == null) {
            floorPriceThreshold = 0L;
        }
        priceProtectParams.setFGiveUpProb(Double.valueOf(0.9));
        if (!StatBaseDo.isCostConfidence(statBaseDo, aFee) || !StatBaseDo.isCostDiffConfidence(statBaseDo, aFee)) {
            priceProtectParams.setFConf(Boolean.valueOf(true));
            floorPriceThreshold = Math.round((double)floorPriceThreshold.longValue() * 0.75);
            priceProtectParams.setFPriceThre(floorPriceThreshold);
            return;
        }
        Long signal = StatBaseDo.getFloorPriceThreDiff(statBaseDo, aFee);
        floorPriceThreshold = floorPriceThreshold + signal;
        floorPriceThreshold = OcpxModelBaseBo.stdwithBoundary(floorPriceThreshold, 0L, floorPrice);
        priceProtectParams.setFConf(Boolean.valueOf(true));
        priceProtectParams.setFPriceThre(floorPriceThreshold);
    }

    public static void getPriceExploreParams(StatBaseDo pkSlotStatBaseDo, StatBaseDo newTradeStatBaseDo, StatBaseDo slotStatBaseDo, OcpxControlParams priceExploreParams) {
        Double slotBidRate;
        Double newTradeSlotBidRate;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{pkSlotStatBaseDo, newTradeStatBaseDo, slotStatBaseDo})) {
            return;
        }
        Double pkSlotBidRate = StatBaseDo.getBidRatio(pkSlotStatBaseDo);
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{pkSlotBidRate, newTradeSlotBidRate = StatBaseDo.getBidRatio(newTradeStatBaseDo), slotBidRate = StatBaseDo.getBidRatio(slotStatBaseDo)})) {
            return;
        }
        Double meanClickFee = DataUtil.division((Long)slotStatBaseDo.getFees(), (Long)slotStatBaseDo.getClickCnt());
        if (meanClickFee == null) {
            return;
        }
        long pkSlotBidCnt = pkSlotStatBaseDo.getBidCnt();
        long newTradeSlotBidCnt = newTradeStatBaseDo.getBidCnt();
        Double bidStatus = DataUtil.division((Double)pkSlotBidRate, (Double)newTradeSlotBidRate);
        if (DataUtil.division((Long)(newTradeSlotBidCnt - pkSlotBidCnt), (Long)newTradeSlotBidCnt) < 1.0E-4) {
            bidStatus = DataUtil.division((Double)pkSlotBidRate, (Double)slotBidRate);
        }
        if (bidStatus == null || bidStatus > 0.5 || pkSlotStatBaseDo.getExpCnt() > 1000L) {
            return;
        }
        Double explorePriceThreshold = 15.0;
        double exploreRate = 0.1;
        exploreRate = (double)((1000L - pkSlotStatBaseDo.getExpCnt()) / 1000L) * exploreRate;
        explorePriceThreshold = (2.0 - bidStatus) * meanClickFee;
        explorePriceThreshold = MathUtil.stdwithBoundary((double)explorePriceThreshold, (double)meanClickFee, (double)(2.0 * meanClickFee));
    }

    public static void getDeepFactor(StatBaseDo pkSlotStatBaseDo, StatBaseDo pkStatBaseDo, StatBaseDo adSlotStatBaseDo, StatBaseDo adStatBaseDo, DeepControlParams params, PackageInfo adPackageInfo) {
        if (adPackageInfo == null) {
            return;
        }
        Double factor = null;
        if (adPackageInfo.getNewTradeTagId() != null && adPackageInfo.getNewTradeTagId().equals(21L)) {
            Double adDcvr = StatBaseDo.getDcvr(adStatBaseDo, 0, 3, null);
            Double adSlotDcvr = StatBaseDo.getDcvr(adSlotStatBaseDo, 0, 3, adDcvr);
            Double pkDcvr = StatBaseDo.getDcvr(pkStatBaseDo, 0, 3, adDcvr);
            Double pkSlotDcvr = StatBaseDo.getDcvr(pkSlotStatBaseDo, 0, 3, adDcvr);
            Double adFactor = null;
            if (adDcvr != null && adSlotDcvr != null) {
                adFactor = DataUtil.division((Double)adSlotDcvr, (Double)adDcvr, (int)5);
            }
            Double pkFactor = null;
            if (pkDcvr != null && pkSlotDcvr != null) {
                pkFactor = DataUtil.division((Double)pkSlotDcvr, (Double)pkDcvr, (int)5);
            }
            if (adFactor != null && pkFactor == null) {
                factor = adFactor;
            }
            if (adFactor != null && pkFactor != null) {
                factor = adFactor * 0.5 + pkFactor * 0.5;
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.9, (double)1.2);
            }
        }
        if (factor != null) {
            params.setDeepFactor(factor);
        }
    }

    public static long stdwithBoundary(long value, long lowB, long upB) {
        return value <= lowB ? lowB : (value > upB ? upB : value);
    }
}

