/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.ocpx.control;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.compute.biz.dto.stat.AdStatusVo;
import cn.com.duiba.nezha.compute.biz.dto.stat.PackageInfo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatBaseDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatOffLineBaseDo;
import cn.com.duiba.nezha.compute.biz.ocpx.control.PID;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import cn.com.duiba.nezha.compute.core.util.MathUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class OcpxModelBaseBo2 {
    private static StatBaseDo statBaseDoTmp = new StatBaseDo();
    private static List<Long> dayAdList = Arrays.asList(72260L, 70386L, 72186L, 72214L);
    private static List<Long> deepTradeList = Arrays.asList(15L, 21L);

    public static void runStat(StatBaseDo statBaseDo, AdControlParams controlParams) {
        if (statBaseDo != null) {
            controlParams.setCtr(StatBaseDo.getCtr(statBaseDo, null));
            controlParams.setCvr0(StatBaseDo.getCvr(statBaseDo, 0, null));
            controlParams.setCvr2(StatBaseDo.getCvr(statBaseDo, 2, null));
            controlParams.setCvr3(StatBaseDo.getCvr(statBaseDo, 3, null));
            controlParams.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
        }
    }

    public static void getColdStart(StatBaseDo adAndSlotStatBaseDo, StatBaseDo slotStatBaseDo, AdControlParams adAndSlotControlParams, SlotControlParams slotControlParams) {
        adAndSlotControlParams.setIsColdStart(Boolean.valueOf(false));
        if (adAndSlotStatBaseDo != null && adAndSlotStatBaseDo.getClickCnt() <= 100L) {
            adAndSlotControlParams.setIsColdStart(Boolean.valueOf(true));
            adAndSlotControlParams.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
        }
        if (slotStatBaseDo != null) {
            slotControlParams.setAvgFee(StatBaseDo.getAvgFee(slotStatBaseDo));
            slotControlParams.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
        }
    }

    public static void getPidFactor(PID pid, StatBaseDo statBaseDoMin, StatBaseDo statBaseDoHour, StatBaseDo statBaseDoDay, int dimType, OcpxControlParams pidParams, OcpxControlParams baseParams, PackageInfo adPackageInfo) {
        if (adPackageInfo == null) {
            return;
        }
        int timeType = 0;
        if (adPackageInfo.getDeepControlType() != null || adPackageInfo.getBackendType() > 0L) {
            timeType = 1;
        }
        if (dayAdList.contains(adPackageInfo.getAdvertId())) {
            timeType = 2;
        }
        OcpxModelBaseBo2.updatePidFactor(pid, statBaseDoMin, statBaseDoHour, statBaseDoDay, timeType, dimType, pidParams, baseParams, adPackageInfo);
    }

    public static void getPidFactor(int controlType, int dimType, PID pid, StatBaseDo statBaseDoMin, StatBaseDo statBaseDoHour, StatBaseDo statBaseDoDay, OcpxControlParams pidParams, OcpxControlParams baseParams, PackageInfo adPackageInfo) {
        if (adPackageInfo == null) {
            return;
        }
        int timeType = 0;
        if (adPackageInfo.getDeepControlType() != null || adPackageInfo.getBackendType() > 0L) {
            timeType = 1;
        }
        if (dayAdList.contains(adPackageInfo.getAdvertId())) {
            timeType = 2;
        }
        if (controlType > 1 && controlType != 4) {
            OcpxModelBaseBo2.updatePidFactor2(controlType, pid, statBaseDoMin, statBaseDoHour, statBaseDoDay, timeType, dimType, pidParams, baseParams, adPackageInfo);
        } else {
            OcpxModelBaseBo2.updatePidFactor(pid, statBaseDoMin, statBaseDoHour, statBaseDoDay, timeType, dimType, pidParams, baseParams, adPackageInfo);
        }
    }

    public static void updatePidFactor(PID pid, StatBaseDo statBaseDoMin, StatBaseDo statBaseDoHour, StatBaseDo statBaseDoDay, int timeType, int dimType, OcpxControlParams pidParams, OcpxControlParams baseParams, PackageInfo adPackageInfo) {
        if (adPackageInfo == null) {
            return;
        }
        if (!(pidParams.getCFactor() != null && pidParams.getCConf() != null && pidParams.getCConf().booleanValue() || baseParams == null)) {
            pidParams.setCFactor(baseParams.getCFactor());
        }
        Double factor = pidParams.getCFactor() == null ? 1.0 : pidParams.getCFactor();
        Double pcFactor = pidParams.getPcFactor() == null ? 1.0 : pidParams.getPcFactor();
        if (adPackageInfo.getReseted() != null && adPackageInfo.getReseted().equals(2L)) {
            factor = 1.0;
            pcFactor = 1.0;
        }
        long aFee = adPackageInfo.getOldConvertCost();
        if (statBaseDoHour == null) {
            statBaseDoHour = statBaseDoTmp;
        }
        if (statBaseDoMin == null) {
            statBaseDoMin = statBaseDoTmp;
        }
        if (!StatBaseDo.isCostConfidence(statBaseDoDay, aFee) && !StatBaseDo.isCostDiffConfidence(statBaseDoDay, aFee) || statBaseDoHour.getOcpcExpCnt() < 10L || statBaseDoMin.getOcpcExpCnt() < 10L) {
            factor = factor + (1.0 - factor) * 0.2;
            pcFactor = pcFactor + (1.0 - pcFactor) * 0.2;
            pidParams.setCConf(Boolean.valueOf(false));
            pidParams.setCFactor(DataUtil.formatDouble((Double)factor, (int)4));
            pidParams.setPcFactor(DataUtil.formatDouble((Double)pcFactor, (int)4));
            return;
        }
        Double target = 0.001;
        int cvrType = adPackageInfo.getBackendType().intValue();
        AdStatusVo statusVoMin = OcpxModelBaseBo2.getStatusVo(statBaseDoMin, aFee, cvrType, 300);
        AdStatusVo statusVoHour = OcpxModelBaseBo2.getStatusVo(statBaseDoHour, aFee, cvrType, 300);
        AdStatusVo statusVoDay = OcpxModelBaseBo2.getStatusVo(statBaseDoDay, aFee, cvrType, 400);
        double pcvrBiasMerge = 0.0;
        if (timeType == 0) {
            pcvrBiasMerge = (1.0 * statusVoMin.confidenceWeight * statusVoMin.pCvrBias + 1.0 * statusVoHour.confidenceWeight * statusVoHour.pCvrBias + 1.0 * statusVoDay.confidenceWeight * statusVoDay.pCvrBias) / (1.0 * statusVoMin.confidenceWeight + 1.0 * statusVoHour.confidenceWeight + 1.0 * statusVoDay.confidenceWeight + 0.01);
            pcvrBiasMerge = Math.max(statusVoDay.confidenceWeight, statusVoHour.confidenceWeight) * pcvrBiasMerge;
            if (statusVoHour.confidenceWeight > 0.1 && statusVoHour.pCvrBias < 0.0 || statusVoMin.confidenceWeight > 0.1 && statusVoMin.pCvrBias < 0.0) {
                pcvrBiasMerge = Math.min(pcvrBiasMerge, 0.0);
            }
            if (statusVoHour.confidenceWeight > 0.1 && statusVoHour.pCvrBias > 0.0 || statusVoMin.confidenceWeight > 0.1 && statusVoMin.pCvrBias > 0.0) {
                pcvrBiasMerge = Math.max(pcvrBiasMerge, 0.0);
            }
        }
        if (timeType == 1) {
            pcvrBiasMerge = (1.0 * statusVoMin.confidenceWeight * statusVoMin.pCvrBias + 1.0 * statusVoHour.confidenceWeight * statusVoHour.pCvrBias) / (1.0 * statusVoMin.confidenceWeight + 1.0 * statusVoHour.confidenceWeight + 0.01);
            pcvrBiasMerge = Math.max(statusVoDay.confidenceWeight, statusVoHour.confidenceWeight) * pcvrBiasMerge;
            if (statusVoHour.confidenceWeight > 0.1 && statusVoHour.pCvrBias < 0.0) {
                pcvrBiasMerge = Math.min(pcvrBiasMerge, 0.0);
            }
            if (statusVoHour.confidenceWeight > 0.1 && statusVoHour.pCvrBias > 0.0) {
                pcvrBiasMerge = Math.max(pcvrBiasMerge, 0.0);
            }
        }
        if (timeType == 2) {
            pcvrBiasMerge = statusVoDay.confidenceWeight * statusVoDay.pCvrBias;
        }
        double factorAvg = StatBaseDo.getCFactorAvg(statBaseDoHour);
        double signal = 0.0;
        if (timeType == 0) {
            signal = pid.update(target, statusVoMin.costBias, statusVoHour.costBias, statusVoDay.costBias, factor, 0.5);
        }
        if (timeType == 1) {
            signal = pid.update(target, statusVoHour.costBias, statusVoDay.costBias, factor, 0.5);
        }
        if (timeType == 2) {
            signal = pid.update(target, statusVoDay.costBias, factor, 0.5);
        }
        factor = 0.01 + 0.99 * (0.9 * factor + 0.1 * factorAvg) + signal;
        if (statusVoDay.costBias < 0.0) {
            factor = Math.max(factor, 0.8);
        }
        if (statusVoDay.costBias > 0.0) {
            factor = Math.min(factor, 0.95);
        }
        factor = MathUtil.stdwithBoundary((double)factor, (double)0.45, (double)1.05);
        double pcFactorLowBound = 0.25;
        double pcFactorUpBound = 3.0;
        if (pcvrBiasMerge < 0.0 && adPackageInfo.getBackendType() > 0L) {
            pcvrBiasMerge = Math.min(0.0, pcvrBiasMerge + 0.05);
        }
        if ((adPackageInfo.getNewTradeTagId() == 16L || adPackageInfo.getNewTradeTagId() == 6L) && pcvrBiasMerge < 0.0) {
            pcvrBiasMerge = Math.min(0.0, pcvrBiasMerge + 0.1);
        }
        Double pcFactorBound = 1.0 / (1.0 + pcvrBiasMerge);
        if (statusVoDay.costBias >= -0.05 && statusVoDay.costBias <= 0.05) {
            pcFactor = 0.9 * pcFactor + 0.1;
        }
        if (statusVoDay.costBias < -0.05 || statusVoDay.costBias > 0.05) {
            Double pcFactorNew = pcFactor - 0.3 * statusVoDay.costBias;
            pcFactor = 0.1 + 0.5 * pcFactorBound + 0.4 * pcFactorNew;
            if (pcFactorBound <= 1.0) {
                long boundLowLevel = Math.min(Math.round(statusVoDay.fee1 / 10000.0), 16L);
                pcFactorLowBound = Math.max(1.0 - 0.05 * (double)boundLowLevel, pcFactorBound);
                pcFactorUpBound = 1.0;
            }
            if (pcFactorBound > 1.0) {
                pcFactorLowBound = 1.0;
                pcFactorUpBound = Math.min(3.0, pcFactorBound);
            }
            if (statusVoDay.costBias > 0.05) {
                pcFactorUpBound = 1.0;
            }
        }
        pcFactor = OcpxModelBaseBo2.stdwithBoundary(pcFactor, pcFactorLowBound, pcFactorUpBound);
        pidParams.setCConf(Boolean.valueOf(true));
        pidParams.setCFactor(DataUtil.formatDouble((Double)factor, (int)3));
        pidParams.setPcFactor(DataUtil.formatDouble((Double)pcFactor, (int)3));
        pidParams.setFcFactor(DataUtil.formatDouble((Double)1.0, (int)3));
        pidParams.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
    }

    public static void updatePidFactor2(int controlType, PID pid, StatBaseDo statBaseDoMin, StatBaseDo statBaseDoHour, StatBaseDo statBaseDoDay, int timeType, int dimType, OcpxControlParams pidParams, OcpxControlParams baseParams, PackageInfo adPackageInfo) {
        double defaultFcFactor;
        double fastTarget;
        if (adPackageInfo == null) {
            return;
        }
        double defaultCFactor = controlType == 2 ? 0.8 : (controlType == 3 ? 0.7 : 0.8);
        double cFactorUpBound = 1.05;
        double cFactorLowBound = 0.3;
        double d = controlType == 2 ? 0.0 : (fastTarget = controlType == 3 ? 0.01 : 0.0);
        double d2 = controlType == 2 ? 1.1 : (defaultFcFactor = controlType == 3 ? 1.2 : 1.0);
        double fcFactorUpBound = controlType == 2 ? 1.15 : (controlType == 3 ? 1.3 : 1.0);
        double fcFactorLowBound = 1.0;
        if (adPackageInfo.getDeepCvrType() != null && adPackageInfo.getDeepFee() != null) {
            fcFactorUpBound = 1.0;
        }
        if (!(pidParams.getCFactor() != null && pidParams.getCConf().booleanValue() || baseParams == null)) {
            pidParams.setCFactor(baseParams.getCFactor());
        }
        Double factor = pidParams.getCFactor() == null ? defaultCFactor : pidParams.getCFactor();
        Double pcFactor = pidParams.getPcFactor() == null ? 1.0 : pidParams.getPcFactor();
        Double fcFactor = pidParams.getFcFactor() == null ? defaultFcFactor : pidParams.getFcFactor();
        if (adPackageInfo.getReseted() != null && adPackageInfo.getReseted().equals(2L)) {
            factor = defaultCFactor;
            pcFactor = 1.0;
            fcFactor = defaultFcFactor;
        }
        long aFee = adPackageInfo.getOldConvertCost();
        long fastAFee = DataUtil.multiply((Long)adPackageInfo.getOldConvertCost(), (Double)(1.0 + fastTarget));
        statBaseDoMin = Optional.ofNullable(statBaseDoMin).orElse(new StatBaseDo());
        statBaseDoHour = Optional.ofNullable(statBaseDoHour).orElse(new StatBaseDo());
        if (!StatBaseDo.isCostConfidence2(statBaseDoDay = Optional.ofNullable(statBaseDoDay).orElse(new StatBaseDo()), aFee, dimType) && !StatBaseDo.isCostDiffConfidence2(statBaseDoDay, aFee, dimType) || statBaseDoHour.getOcpcExpCnt() < 10L || statBaseDoMin.getOcpcExpCnt() < 10L) {
            factor = factor + (defaultCFactor - factor) * 0.2;
            pcFactor = pcFactor + (1.0 - pcFactor) * 0.2;
            fcFactor = fcFactor + (defaultFcFactor - fcFactor) * 0.2;
            factor = MathUtil.stdwithBoundary((double)factor, (double)cFactorLowBound, (double)cFactorUpBound);
            fcFactor = MathUtil.stdwithBoundary((double)fcFactor, (double)fcFactorLowBound, (double)fcFactorUpBound);
            pidParams.setCConf(Boolean.valueOf(false));
            pidParams.setCFactor(DataUtil.formatDouble((Double)factor, (int)4));
            pidParams.setPcFactor(DataUtil.formatDouble((Double)pcFactor, (int)4));
            pidParams.setFcFactor(DataUtil.formatDouble((Double)fcFactor, (int)4));
            return;
        }
        Double target = 0.001;
        int cvrType = adPackageInfo.getBackendType().intValue();
        AdStatusVo statusVoMin = OcpxModelBaseBo2.getStatusVo2(statBaseDoMin, aFee, cvrType, 300, fastAFee, fastTarget, dimType);
        AdStatusVo statusVoHour = OcpxModelBaseBo2.getStatusVo2(statBaseDoHour, aFee, cvrType, 300, fastAFee, fastTarget, dimType);
        AdStatusVo statusVoDay = OcpxModelBaseBo2.getStatusVo2(statBaseDoDay, aFee, cvrType, 400, fastAFee, fastTarget, dimType);
        double pcvrBiasMerge = 0.0;
        if (timeType == 0) {
            pcvrBiasMerge = (1.0 * statusVoMin.confidenceWeight * statusVoMin.pCvrBias + 1.0 * statusVoHour.confidenceWeight * statusVoHour.pCvrBias + 1.0 * statusVoDay.confidenceWeight * statusVoDay.pCvrBias) / (1.0 * statusVoMin.confidenceWeight + 1.0 * statusVoHour.confidenceWeight + 1.0 * statusVoDay.confidenceWeight + 0.01);
            pcvrBiasMerge = Math.max(statusVoDay.confidenceWeight, statusVoHour.confidenceWeight) * pcvrBiasMerge;
            if (statusVoHour.confidenceWeight > 0.1 && statusVoHour.pCvrBias < 0.0 || statusVoMin.confidenceWeight > 0.1 && statusVoMin.pCvrBias < 0.0) {
                pcvrBiasMerge = Math.min(pcvrBiasMerge, 0.0);
            }
            if (statusVoHour.confidenceWeight > 0.1 && statusVoHour.pCvrBias > 0.0 || statusVoMin.confidenceWeight > 0.1 && statusVoMin.pCvrBias > 0.0) {
                pcvrBiasMerge = Math.max(pcvrBiasMerge, 0.0);
            }
        }
        if (timeType == 1) {
            pcvrBiasMerge = (1.0 * statusVoMin.confidenceWeight * statusVoMin.pCvrBias + 1.0 * statusVoHour.confidenceWeight * statusVoHour.pCvrBias) / (1.0 * statusVoMin.confidenceWeight + 1.0 * statusVoHour.confidenceWeight + 0.01);
            pcvrBiasMerge = Math.max(statusVoDay.confidenceWeight, statusVoHour.confidenceWeight) * pcvrBiasMerge;
            if (statusVoHour.confidenceWeight > 0.1 && statusVoHour.pCvrBias < 0.0) {
                pcvrBiasMerge = Math.min(pcvrBiasMerge, 0.0);
            }
            if (statusVoHour.confidenceWeight > 0.1 && statusVoHour.pCvrBias > 0.0) {
                pcvrBiasMerge = Math.max(pcvrBiasMerge, 0.0);
            }
        }
        if (timeType == 2) {
            pcvrBiasMerge = statusVoDay.confidenceWeight * statusVoDay.pCvrBias;
        }
        double pcFactorLowBound = 0.25;
        double pcFactorUpBound = 3.0;
        if (pcvrBiasMerge < 0.0 && adPackageInfo.getBackendType() > 0L) {
            pcvrBiasMerge = Math.min(0.0, pcvrBiasMerge + 0.05);
        }
        Double pcFactorBound = 1.0 / (1.0 + pcvrBiasMerge);
        if (statusVoDay.costBias >= -0.05 && statusVoDay.costBias <= 0.05) {
            pcFactor = 0.9 * pcFactor + 0.1;
        }
        if (statusVoDay.costBias < -0.05 || statusVoDay.costBias > 0.05) {
            Double pcFactorNew = pcFactor - 0.3 * statusVoDay.costBias;
            pcFactor = 0.1 + 0.5 * pcFactorBound + 0.4 * pcFactorNew;
            if (pcFactorBound <= 1.0) {
                long boundLowLevel = Math.min(Math.round(statusVoDay.fee1 / 10000.0), 16L);
                pcFactorLowBound = Math.max(1.0 - 0.05 * (double)boundLowLevel, pcFactorBound);
                pcFactorUpBound = 1.0;
            }
            if (pcFactorBound > 1.0) {
                pcFactorLowBound = 1.0;
                pcFactorUpBound = Math.min(3.0, pcFactorBound);
            }
            if (statusVoDay.costBias > 0.05) {
                pcFactorUpBound = 1.0;
            }
        }
        pcFactor = OcpxModelBaseBo2.stdwithBoundary(pcFactor, pcFactorLowBound, pcFactorUpBound);
        double lastFcFactor = fcFactor;
        double fastSignal = 0.0;
        if (timeType == 0) {
            fastSignal = pid.update(target, statusVoMin.fastCostBias, statusVoHour.fastCostBias, statusVoDay.fastCostBias, fcFactor, 0.5);
        }
        if (timeType == 1) {
            fastSignal = pid.update(target, statusVoHour.fastCostBias, statusVoDay.fastCostBias, fcFactor, 0.5);
        }
        if (timeType == 2) {
            fastSignal = pid.update(target, statusVoDay.costBias, fcFactor, 0.5);
        }
        fcFactor = 0.01 + 0.99 * fcFactor + fastSignal;
        fcFactor = MathUtil.stdwithBoundary((double)fcFactor, (double)fcFactorLowBound, (double)fcFactorUpBound);
        double factorAvg = StatBaseDo.getCFactorAvg(statBaseDoHour);
        double signal = 0.0;
        if (timeType == 0) {
            signal = pid.update(target, statusVoMin.costBias, statusVoHour.costBias, statusVoDay.costBias, factor, 0.5);
        }
        if (timeType == 1) {
            signal = pid.update(target, statusVoHour.costBias, statusVoDay.costBias, factor, 0.5);
        }
        if (timeType == 2) {
            signal = pid.update(target, statusVoDay.costBias, factor, 0.5);
        }
        factor = 0.01 + 0.99 * (0.9 * factor + 0.1 * factorAvg) + signal;
        if (lastFcFactor == fcFactorUpBound && statusVoDay.costBias < -0.1) {
            factor = Math.max(factor, defaultCFactor);
        } else if (lastFcFactor == fcFactorLowBound && statusVoDay.costBias > 0.1) {
            factor = Math.min(factor, defaultCFactor);
        }
        factor = MathUtil.stdwithBoundary((double)factor, (double)cFactorLowBound, (double)cFactorUpBound);
        pidParams.setCConf(Boolean.valueOf(true));
        pidParams.setCFactor(DataUtil.formatDouble((Double)factor, (int)3));
        pidParams.setPcFactor(DataUtil.formatDouble((Double)pcFactor, (int)3));
        pidParams.setFcFactor(DataUtil.formatDouble((Double)fcFactor, (int)3));
        pidParams.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
    }

    public static void getFloorPriceParams(StatBaseDo statBaseDo, OcpxControlParams priceProtectParams, Long aFee) {
        Long floorPrice = 12L;
        Long floorPriceThreshold = priceProtectParams.getFPriceThre();
        if (floorPriceThreshold == null) {
            floorPriceThreshold = 0L;
        }
        priceProtectParams.setFGiveUpProb(Double.valueOf(0.9));
        if (!StatBaseDo.isCostConfidence(statBaseDo, aFee) || !StatBaseDo.isCostDiffConfidence(statBaseDo, aFee)) {
            priceProtectParams.setFConf(Boolean.valueOf(true));
            floorPriceThreshold = Math.round((double)floorPriceThreshold.longValue() * 0.75);
            priceProtectParams.setFPriceThre(floorPriceThreshold);
            return;
        }
        Long signal = StatBaseDo.getFloorPriceThreDiff(statBaseDo, aFee);
        floorPriceThreshold = floorPriceThreshold + signal;
        floorPriceThreshold = OcpxModelBaseBo2.stdwithBoundary(floorPriceThreshold, 0L, floorPrice);
        priceProtectParams.setFConf(Boolean.valueOf(true));
        priceProtectParams.setFPriceThre(floorPriceThreshold);
        priceProtectParams.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
    }

    public static void getPriceExploreParams(StatBaseDo pkSlotStatBaseDo, StatBaseDo newTradeStatBaseDo, StatBaseDo slotStatBaseDo, OcpxControlParams priceExploreParams) {
        Double slotBidRate;
        Double newTradeSlotBidRate;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{pkSlotStatBaseDo, newTradeStatBaseDo, slotStatBaseDo})) {
            return;
        }
        Double pkSlotBidRate = StatBaseDo.getBidRatio(pkSlotStatBaseDo);
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{pkSlotBidRate, newTradeSlotBidRate = StatBaseDo.getBidRatio(newTradeStatBaseDo), slotBidRate = StatBaseDo.getBidRatio(slotStatBaseDo)})) {
            return;
        }
        Double meanClickFee = DataUtil.division((Long)slotStatBaseDo.getFees(), (Long)slotStatBaseDo.getClickCnt());
        if (meanClickFee == null) {
            return;
        }
        long pkSlotBidCnt = pkSlotStatBaseDo.getBidCnt();
        long newTradeSlotBidCnt = newTradeStatBaseDo.getBidCnt();
        Double bidStatus = DataUtil.division((Double)pkSlotBidRate, (Double)newTradeSlotBidRate);
        if (DataUtil.division((Long)(newTradeSlotBidCnt - pkSlotBidCnt), (Long)newTradeSlotBidCnt) < 1.0E-4) {
            bidStatus = DataUtil.division((Double)pkSlotBidRate, (Double)slotBidRate);
        }
        if (bidStatus == null || bidStatus > 0.5 || pkSlotStatBaseDo.getExpCnt() > 1000L) {
            return;
        }
        Double explorePriceThreshold = 15.0;
        double exploreRate = 0.1;
        exploreRate = (double)((1000L - pkSlotStatBaseDo.getExpCnt()) / 1000L) * exploreRate;
        explorePriceThreshold = (2.0 - bidStatus) * meanClickFee;
        explorePriceThreshold = MathUtil.stdwithBoundary((double)explorePriceThreshold, (double)meanClickFee, (double)(2.0 * meanClickFee));
    }

    public static void getDeepFactor(int dimType, StatBaseDo pkSlotStatBaseDo, StatBaseDo pkStatBaseDo, StatBaseDo adSlotStatBaseDo, StatBaseDo adStatBaseDo, StatOffLineBaseDo pkSlotStatOffLineBaseDo, StatOffLineBaseDo pkStatOffLineBaseDo, StatOffLineBaseDo adSlotStatOffLineBaseDo, StatOffLineBaseDo adStatOffLineBaseDo, DeepControlParams params, PackageInfo adPackageInfo) {
        if (!PackageInfo.deepValid(adPackageInfo)) {
            params.setDeepFactor(Double.valueOf(1.0));
            return;
        }
        Double factor = 1.0;
        Double factor1 = 1.0;
        Double factor2 = 1.0;
        int startType = adPackageInfo.getBackendType().intValue();
        int endType = adPackageInfo.getDeepCvrType().intValue();
        Double adDcvrOffLine = StatOffLineBaseDo.getDcvr(adStatOffLineBaseDo, startType, endType, null);
        Double adSlotDcvrOffLine = StatOffLineBaseDo.getDcvr(adSlotStatOffLineBaseDo, startType, endType, adDcvrOffLine);
        Double pkDcvrOffLine = StatOffLineBaseDo.getDcvr(pkStatOffLineBaseDo, startType, endType, adDcvrOffLine);
        Double pkSlotDcvrOffLine = StatOffLineBaseDo.getDcvr(pkSlotStatOffLineBaseDo, startType, endType, adSlotDcvrOffLine);
        if (pkSlotDcvrOffLine == null) {
            pkSlotDcvrOffLine = pkDcvrOffLine;
        }
        if (adPackageInfo.getDeepControlType() == null || adPackageInfo.getDeepControlType().equals(1L) || endType > 8) {
            Double adFactor = DataUtil.division((Double)adSlotDcvrOffLine, (Double)adDcvrOffLine, (int)5);
            Double pkFactor = DataUtil.division((Double)pkSlotDcvrOffLine, (Double)pkDcvrOffLine, (int)5);
            if (adFactor != null && pkFactor == null) {
                factor = adFactor;
            }
            if (adFactor != null && pkFactor != null) {
                factor = adFactor * 0.5 + pkFactor * 0.5;
                factor = 1.0 + 0.6 * (factor - 1.0);
            }
            factor = MathUtil.stdwithBoundary((Double)factor, (double)0.95, (double)1.3, (int)5);
        } else {
            Double pkFactor1;
            Double adDcvr = StatBaseDo.getDcvr(adStatBaseDo, startType, endType, adDcvrOffLine);
            Double adSlotDcvr = StatBaseDo.getDcvr(adSlotStatBaseDo, startType, endType, adSlotDcvrOffLine);
            if (adSlotDcvr == null) {
                adSlotDcvr = adDcvr;
            }
            Double pkDcvr = StatBaseDo.getDcvr(pkStatBaseDo, startType, endType, pkDcvrOffLine);
            Double pkSlotDcvr = StatBaseDo.getDcvr(pkSlotStatBaseDo, startType, endType, pkSlotDcvrOffLine);
            if (pkSlotDcvr == null) {
                pkSlotDcvr = pkDcvr;
            }
            if ((pkFactor1 = DataUtil.division((Double)pkSlotDcvr, (Double)pkDcvr, (int)5)) != null) {
                factor1 = 1.0 + 0.7 * (pkFactor1 - 1.0);
            }
            Double adFactor2 = null;
            Double pkFactor2 = null;
            if (adSlotDcvr != null) {
                adFactor2 = (double)adPackageInfo.getDeepFee().longValue() * adSlotDcvr / (double)adPackageInfo.getOldConvertCost().longValue();
            }
            if (pkSlotDcvr != null) {
                pkFactor2 = (double)adPackageInfo.getDeepFee().longValue() * pkSlotDcvr / (double)adPackageInfo.getOldConvertCost().longValue();
            }
            if (pkFactor2 == null) {
                pkFactor2 = adFactor2;
            }
            if (adFactor2 == null) {
                adFactor2 = pkFactor2;
            }
            if (adFactor2 != null && pkFactor2 != null) {
                factor2 = adFactor2 * 0.3 + pkFactor2 * 0.7;
            }
            if (adPackageInfo.getPackageId().equals(0L) && adPackageInfo.getAdvertId().equals(62556L)) {
                System.out.println("f1=" + factor1 + ",f2=" + factor2);
            }
            if (adPackageInfo.getDeepControlType().equals(2L)) {
                factor = factor2;
                factor = factor < 1.0 ? Double.valueOf(1.0 + 0.5 * (factor - 1.0)) : Double.valueOf(1.0 + 0.9 * (factor - 1.0));
            }
            if (adPackageInfo.getDeepControlType().equals(3L)) {
                if (factor2 < 1.0) {
                    factor = Math.max(factor1, factor2);
                    factor = Math.min(factor, 1.03);
                } else {
                    factor = factor2;
                }
                if (factor < 0.9) {
                    factor = 1.0 + 0.7 * (factor - 0.9);
                    factor = Math.max(0.95, factor);
                } else {
                    factor = factor < 1.0 ? Double.valueOf(1.0) : Double.valueOf(1.0 + 0.9 * (factor - 1.0));
                }
            }
            factor = MathUtil.stdwithBoundary((Double)factor, (double)0.95, (double)1.3, (int)5);
        }
        params.setDeepFactor(factor);
        params.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
    }

    public static AdStatusVo getStatusVo(StatBaseDo statBaseDo, Long afee, int cvrType, int confidenceBase) {
        AdStatusVo adStatusVo = new AdStatusVo();
        if (statBaseDo != null && statBaseDo.getOcpcExpCnt() > 0L) {
            Double costBias = StatBaseDo.getCostBias(statBaseDo, afee, 0.0);
            Double pCvrBias = StatBaseDo.getPCvrBias(statBaseDo, cvrType, 0.0);
            long ocpcFees = statBaseDo.getOcpcFees();
            double confidenceWeight = Math.min(((double)ocpcFees + 0.0) / (double)(confidenceBase * 100), 1.0);
            Double pcFactorAvg = statBaseDo.getOcpcFactorSum() / (double)statBaseDo.getOcpcExpCnt();
            Double cFactorAvg = statBaseDo.getSecondFactorSum() / (double)statBaseDo.getOcpcExpCnt();
            Double dFactorAvg = statBaseDo.getDeepFactorSum() / (double)statBaseDo.getOcpcExpCnt();
            adStatusVo.setExpCnt(statBaseDo.getOcpcExpCnt());
            adStatusVo.setCostBias(costBias);
            adStatusVo.setPCvrBias(pCvrBias);
            adStatusVo.setFee1(statBaseDo.getOcpcFees());
            adStatusVo.setFee2(statBaseDo.getOcpcFees2());
            adStatusVo.setFee3(statBaseDo.getOcpcFees3());
            adStatusVo.setConfidenceWeight(confidenceWeight);
            adStatusVo.setPcFactorAvg(DataUtil.formatDouble((Double)pcFactorAvg, (int)2));
            adStatusVo.setCFactorAvg(DataUtil.formatDouble((Double)cFactorAvg, (int)2));
            adStatusVo.setDFactorAvg(DataUtil.formatDouble((Double)dFactorAvg, (int)2));
        }
        return adStatusVo;
    }

    public static AdStatusVo getStatusVo2(StatBaseDo statBaseDo, Long afee, int cvrType, int confidenceBase, Long fastAFee, double fastTarget, int dimType) {
        AdStatusVo adStatusVo = new AdStatusVo();
        if (statBaseDo != null && statBaseDo.getOcpcExpCnt() > 0L) {
            Double costBias = StatBaseDo.getCostBias(statBaseDo, afee, 0.0);
            Double pCvrBias = StatBaseDo.getPCvrBias(statBaseDo, cvrType, 0.0);
            Double fastCostBias = StatBaseDo.getFastCostBias(statBaseDo, fastAFee, fastTarget, dimType, 0.0);
            long fastFees2 = DataUtil.double2Long((Double)((double)statBaseDo.getOcpcFees2() * (1.0 + fastTarget)));
            long fastFees3 = DataUtil.double2Long((Double)((double)statBaseDo.getOcpcFees3() * (1.0 + fastTarget)));
            long ocpcFees = statBaseDo.getOcpcFees();
            double confidenceWeight = Math.min(((double)ocpcFees + 0.0) / (double)(confidenceBase * 100), 1.0);
            Double pcFactorAvg = statBaseDo.getOcpcFactorSum() / (double)statBaseDo.getOcpcExpCnt();
            Double cFactorAvg = statBaseDo.getSecondFactorSum() / (double)statBaseDo.getOcpcExpCnt();
            Double dFactorAvg = statBaseDo.getDeepFactorSum() / (double)statBaseDo.getOcpcExpCnt();
            adStatusVo.setFastCostBias(fastCostBias);
            adStatusVo.setFastFee2(fastFees2);
            adStatusVo.setFastFee3(fastFees3);
            adStatusVo.setExpCnt(statBaseDo.getOcpcExpCnt());
            adStatusVo.setCostBias(costBias);
            adStatusVo.setPCvrBias(pCvrBias);
            adStatusVo.setFee1(statBaseDo.getOcpcFees());
            adStatusVo.setFee2(statBaseDo.getOcpcFees2());
            adStatusVo.setFee3(statBaseDo.getOcpcFees3());
            adStatusVo.setConfidenceWeight(confidenceWeight);
            adStatusVo.setPcFactorAvg(DataUtil.formatDouble((Double)pcFactorAvg, (int)2));
            adStatusVo.setCFactorAvg(DataUtil.formatDouble((Double)cFactorAvg, (int)2));
            adStatusVo.setDFactorAvg(DataUtil.formatDouble((Double)dFactorAvg, (int)2));
        }
        return adStatusVo;
    }

    public static long stdwithBoundary(long value, long lowB, long upB) {
        return value <= lowB ? lowB : (value > upB ? upB : value);
    }

    public static double stdwithBoundary(double value, double lowB, double upB) {
        return value <= lowB ? lowB : (value > upB ? upB : value);
    }
}

