/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.ps;

import cn.com.duiba.nezha.compute.biz.bo.IPsBo;
import cn.com.duiba.nezha.compute.biz.bo.PsBo;
import cn.com.duiba.nezha.compute.biz.bo.PsRedisBo;
import cn.com.duiba.nezha.compute.biz.dto.PsModelBaseInfo;
import cn.com.duiba.nezha.compute.biz.enums.hbase.HbaseOpsEnum;
import cn.com.duiba.nezha.compute.biz.enums.model.PsTypeEnum;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.model.local.LocalModel;
import cn.com.duiba.nezha.compute.core.model.ps.PsModel;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import com.alibaba.fastjson.JSON;

public class PsAgent {
    public static DateStyle dateStyle = DateStyle.YYYY_MM_DD_HH_MM_SS;
    public PsTypeEnum type;
    public String modelId;
    public int parSize;
    public int dim;
    public int factorNum;
    public PsModelBaseInfo baseInfo;
    public LocalModel localModel;
    public IPsBo psBo;

    public PsTypeEnum getType() {
        return this.type;
    }

    public void setType(PsTypeEnum type) {
        this.type = type;
    }

    public PsAgent(String modelId) {
        this.modelId = modelId;
        this.pullBaseInfo();
    }

    public PsAgent(String modelId, PsTypeEnum type) {
        this.modelId = modelId;
        this.type = type;
        this.pullBaseInfo();
    }

    public PsAgent(String modelId, int parSize, int dim) {
        this.modelId = modelId;
        this.parSize = parSize;
        this.dim = dim;
    }

    public PsAgent(String modelId, int parSize, int dim, int factorNum) {
        this.modelId = modelId;
        this.parSize = parSize;
        this.dim = dim;
        this.factorNum = factorNum;
    }

    public IPsBo getPsBo() {
        if (this.psBo == null) {
            if (PsTypeEnum.REDIS.equals((Object)this.type)) {
                System.out.println("getPsBo(),set psbo with redis");
                this.setPsBo(new PsRedisBo());
            }
            if (PsTypeEnum.HBASE.equals((Object)this.type)) {
                System.out.println("getPsBo(),set psbo with hbase");
                this.setPsBo(new PsBo());
            }
            if (null == this.type) {
                this.initPsBo();
            }
        }
        return this.psBo;
    }

    public void setPsBo(IPsBo psBo) {
        this.psBo = psBo;
    }

    public void initPsBo() {
        try {
            PsRedisBo psBoR = new PsRedisBo();
            if (DateUtil.getCurrentTime().compareTo("2020-04-03 23:00:00") < 0) {
                PsModelBaseInfo baseInfo = psBoR.getPsBaseInfo(this.getModelId());
                if (baseInfo != null) {
                    System.out.println("initPsBo(), default with redis");
                    this.setPsBo(psBoR);
                } else {
                    System.out.println("initPsBo(), default with hbase");
                    this.setPsBo(new PsBo());
                }
            } else {
                System.out.println("initPsBo(),  default with redis");
                this.setPsBo(psBoR);
            }
        }
        catch (Exception e) {
            System.out.println("initPsBo error" + e);
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public int getParSize() {
        if (this.parSize == 0) {
            return this.getBaseInfo().getParSize();
        }
        return this.parSize;
    }

    public int getDim() {
        if (this.dim == 0) {
            return this.getBaseInfo().getDim();
        }
        return this.dim;
    }

    public void setBaseInfo(PsModelBaseInfo baseInfo) {
        System.out.println("setBaseInfo=" + JSON.toJSONString((Object)baseInfo));
        this.baseInfo = baseInfo;
    }

    public PsModelBaseInfo getBaseInfo() {
        if (this.baseInfo == null) {
            this.pullBaseInfo();
        }
        return this.baseInfo;
    }

    public void setLocalModel(LocalModel localModel) {
        this.localModel = localModel;
    }

    public LocalModel getLocalModel() {
        return this.localModel;
    }

    public int getPsDim() {
        int ret = 0;
        try {
            if (this.getDim() == 0) {
                this.pullBaseInfo();
            }
            ret = this.getBaseInfo().getDim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int getPsParSize() {
        int ret = 0;
        try {
            if (this.getDim() == 0) {
                this.pullBaseInfo();
            }
            ret = this.getBaseInfo().getParSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean pullBaseInfo() {
        boolean ret = true;
        try {
            if (this.baseInfo == null) {
                PsModelBaseInfo baseInfo = this.getPsBo().getPsBaseInfo(this.modelId);
                System.out.println("baseinfo is null , get from ps, baseinfo=" + JSON.toJSONString((Object)baseInfo));
                if (baseInfo != null) {
                    this.setBaseInfo(baseInfo);
                } else {
                    this.initBaseInfoLocal();
                    ret = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void initBaseInfoLocal() {
        if (this.dim > 0 && this.parSize > 0) {
            PsModelBaseInfo baseInfo2 = new PsModelBaseInfo();
            baseInfo2.setModelId(this.modelId);
            baseInfo2.setParSize(this.parSize);
            baseInfo2.setVersion(0);
            baseInfo2.setDim(this.dim);
            baseInfo2.setFactorNum(this.factorNum);
            baseInfo2.setCreateTime(DateUtil.getCurrentTime((DateStyle)dateStyle));
            this.setBaseInfo(baseInfo2);
        }
    }

    public void pushBaseInfo() {
        try {
            if (this.getModelId() != null && this.getBaseInfo() != null) {
                if (this.getBaseInfo().getDim() == 0) {
                    this.getBaseInfo().setDim(this.dim);
                }
                if (this.getBaseInfo().getParSize() == 0) {
                    this.getBaseInfo().setParSize(this.parSize);
                }
                if (this.factorNum > 0) {
                    this.getBaseInfo().setFactorNum(this.factorNum);
                }
                System.out.println(" pushBaseInfo() =" + JSON.toJSONString((Object)this.getBaseInfo()));
                this.getPsBo().updatePsBaseInfo(this.modelId, this.getBaseInfo());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean pull(LocalModel searchLocalModel, boolean isAll) {
        boolean status = true;
        try {
            System.out.println("pull ps model  start");
            if (searchLocalModel != null) {
                if (this.getBaseInfo().getUpdateTime() != null) {
                    PsModel psModel = searchLocalModel.toPsModel(this.getParSize());
                    PsModel ret = this.getPsBo().searchPsModel(psModel, this.getBaseInfo(), isAll);
                    if (ret != null) {
                        this.setLocalModel(ret.toLocalModel());
                    } else {
                        this.setLocalModel(LocalModel.getInstance());
                    }
                    int iM = DateUtil.getIntervalMinutes((String)DateUtil.getCurrentTime(), (String)this.getBaseInfo().getUpdateTime(), (DateStyle)dateStyle);
                    if (Math.abs(iM) > 60) {
                        status = false;
                    }
                } else {
                    System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " ps pull model is not exists ,init with null");
                    this.setLocalModel(LocalModel.getInstance());
                }
            }
            System.out.println("pull ps model end ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public boolean pullAll(LocalModel searchLocalModel) {
        boolean status = true;
        try {
            if (searchLocalModel != null) {
                System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " [INFO] ps pull model is exists ,init from ps");
                PsModel psModel = searchLocalModel.toPsModel(this.parSize);
                PsModel ret = this.getPsBo().searchPsModel(psModel, this.getBaseInfo(), true);
                if (ret != null) {
                    this.setLocalModel(ret.toLocalModel());
                } else {
                    this.setLocalModel(LocalModel.getInstance());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public boolean pullAll(LocalModel searchLocalModel, PsModelBaseInfo baseInfo) {
        boolean status = true;
        try {
            if (searchLocalModel != null) {
                System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " [INFO] ps pull model is exists ,init from ps");
                PsModel psModel = searchLocalModel.toPsModel(this.parSize);
                PsModel ret = this.getPsBo().searchPsModel(psModel, baseInfo, true);
                if (ret != null) {
                    this.setLocalModel(ret.toLocalModel());
                } else {
                    this.setLocalModel(LocalModel.getInstance());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public void push(LocalModel deltaLocalModel, double ratio) throws Exception {
        this.push(deltaLocalModel);
    }

    public void push(LocalModel deltaLocalModel) throws Exception {
        try {
            if (deltaLocalModel != null) {
                PsModel psModel = deltaLocalModel.toPsModel(this.getBaseInfo().getParSize());
                this.getPsBo().updatePsModel(psModel, this.getBaseInfo(), HbaseOpsEnum.INCREMENT);
                this.getBaseInfo().setUpdateTime(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
                this.pushBaseInfo();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void push(LocalModel deltaLocalModel, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        try {
            if (deltaLocalModel != null) {
                System.out.println("push");
                this.pullBaseInfo();
                PsModel psModel = deltaLocalModel.toPsModel(this.getBaseInfo().getParSize());
                this.getPsBo().updatePsModel(psModel, this.getBaseInfo(), hbaseOpsEnum);
                this.getBaseInfo().setUpdateTime(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
                this.pushBaseInfo();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pushAll(LocalModel deltaLocalModel, PsModelBaseInfo baseInfo) throws Exception {
        try {
            if (deltaLocalModel != null) {
                System.out.println("pushAll ps model  start");
                PsModel psModel = deltaLocalModel.toPsModel(baseInfo.getParSize());
                this.getPsBo().updatePsModel(psModel, baseInfo, HbaseOpsEnum.INSERT_AND_UPDATE);
                this.setBaseInfo(baseInfo);
                this.getBaseInfo().setUpdateTime(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
                this.pushBaseInfo();
                System.out.println("pushAll ps model  end");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pushAll(LocalModel deltaLocalModel) throws Exception {
        try {
            if (deltaLocalModel != null) {
                System.out.println("pushAll ps model  start");
                PsModel psModel = deltaLocalModel.toPsModel(this.getBaseInfo().getParSize());
                this.getPsBo().updatePsModel(psModel, this.getBaseInfo(), HbaseOpsEnum.INSERT_AND_UPDATE);
                this.getBaseInfo().setUpdateTime(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
                this.pushBaseInfo();
                System.out.println("push ps model  end");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rebuild(LocalModel searchLocalModel, int dim) {
        try {
            this.pull(searchLocalModel, true);
            PsModelBaseInfo oldBaseInfo = this.getBaseInfo();
            PsModelBaseInfo newBaseInfo = new PsModelBaseInfo();
            newBaseInfo.setParSize(this.getParSize());
            newBaseInfo.setVersion(oldBaseInfo.getVersion() + 1);
            newBaseInfo.setModelId(this.getModelId());
            newBaseInfo.setCreateTime(oldBaseInfo.getCreateTime());
            newBaseInfo.setUpdateTime(DateUtil.getCurrentTime((DateStyle)dateStyle));
            this.setBaseInfo(newBaseInfo);
            this.push(this.getLocalModel(), 1.0);
            PsModel psModel = this.getLocalModel().toPsModel(oldBaseInfo.getParSize());
            this.getPsBo().updatePsModel(psModel, oldBaseInfo, HbaseOpsEnum.DELETE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete(LocalModel searchLocalModel) {
        try {
            PsModelBaseInfo oldBaseInfo = this.getBaseInfo();
            PsModel psModel = searchLocalModel.toPsModel(oldBaseInfo.getParSize());
            this.getPsBo().updatePsModel(psModel, oldBaseInfo, HbaseOpsEnum.DELETE);
            this.getPsBo().deletePsBaseInfo(oldBaseInfo.getModelId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete() {
        try {
            PsModelBaseInfo oldBaseInfo = this.getBaseInfo();
            System.out.println("oldBaseInfo" + JSON.toJSONString((Object)oldBaseInfo));
            PsModel psModel = this.getLocalModel().toPsModel(oldBaseInfo.getParSize());
            this.getPsBo().updatePsModel(psModel, oldBaseInfo, HbaseOpsEnum.DELETE);
            this.getPsBo().deletePsBaseInfo(oldBaseInfo.getModelId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

