/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.utils.jedis;

import cn.com.duiba.nezha.compute.biz.conf.JedisConfig;
import cn.com.duiba.nezha.compute.biz.conf.JedisPoolConf;
import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolUtil {
    private static Map<String, JedisPool> maps = new HashMap<String, JedisPool>();

    private JedisPoolUtil() {
    }

    public static JedisPoolUtil getInstance() {
        return RedisUtilHolder.instance;
    }

    public static JedisPool getPool(JedisConfig jedisConfig) {
        JedisPool pool = null;
        int timeOut = 5000;
        String ip = jedisConfig.getIp();
        int port = jedisConfig.getPort();
        String passWord = jedisConfig.getPassWord();
        String key = ip + ":" + port;
        if (!maps.containsKey(key)) {
            JedisPoolConfig config = JedisPoolConf.poolConfig;
            pool = new JedisPool((GenericObjectPoolConfig)config, ip, port, timeOut, passWord);
            maps.put(key, pool);
            System.out.println("put new pool");
        } else {
            pool = maps.get(key);
        }
        return pool;
    }

    public Jedis getJedis(JedisConfig jedisConfig) {
        Jedis jedis = null;
        int count = 0;
        do {
            try {
                jedis = JedisPoolUtil.getPool(jedisConfig).getResource();
            }
            catch (Exception e) {
                e.printStackTrace();
                JedisPoolUtil.getPool(jedisConfig);
            }
        } while (jedis == null && count < ProjectConstant.RETRY_NUM);
        return jedis;
    }

    private static class RedisUtilHolder {
        private static final JedisPoolUtil instance = new JedisPoolUtil();

        private RedisUtilHolder() {
        }
    }
}

