/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.utils.jedis;

import cn.com.duiba.nezha.compute.biz.conf.JedisConfig;
import cn.com.duiba.nezha.compute.biz.utils.jedis.JedisPoolUtil;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class JedisUtil {
    private JedisConfig jedisConfig;

    public JedisUtil(JedisConfig jedisConfig) {
        this.jedisConfig = jedisConfig;
    }

    public Jedis getJedis() {
        Jedis jedis = null;
        try {
            jedis = JedisPoolUtil.getInstance().getJedis(this.jedisConfig);
        }
        catch (Exception e) {
            System.out.println("redis error " + e);
        }
        return jedis;
    }

    public void remove(String ... keys) {
        try {
            for (String key : keys) {
                this.remove(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Jedis jedis = this.getJedis();
        boolean isBroken = false;
        try {
            if (this.exists(key)) {
                jedis.del(key);
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        boolean ret = false;
        Jedis jedis = this.getJedis();
        boolean isBroken = false;
        try {
            ret = jedis.exists(key);
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) {
        String result = null;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            result = jedis.get(key);
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String result = null;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            result = jedis.get(key);
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key, Class clazz) {
        Object result = null;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            Object value = this.getObject(key);
            result = JSON.parseObject((String)((String)value), (Class)clazz);
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setObject(String key, Object value) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.set(key, JSON.toJSONString((Object)value));
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, String value) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.set(key, value);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String key) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.del(key);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setObjectex(String key, Object value, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.setex(key, seconds, JSON.toJSONString((Object)value));
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setex(String key, String value, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.setex(key, seconds, value);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    public <T> List<T> getList(String key, Class clazz) {
        List result = null;
        try {
            Object value = this.getObject(key);
            result = JSON.parseArray((String)((String)value), (Class)clazz);
        }
        catch (Exception e) {
            System.out.println("redis error " + e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setexList(String key, Object list, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            String value = JSON.toJSONString((Object)list);
            jedis.setex(key, seconds, value);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean multiSetexT(Map<String, T> kvMap, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (AssertUtil.isNotEmpty(kvMap)) {
                int index = 0;
                for (Map.Entry<String, T> entry : kvMap.entrySet()) {
                    String key = entry.getKey();
                    T value = entry.getValue();
                    String jsonValue = JSON.toJSONString(value);
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key, jsonValue})) continue;
                    p.set(key, jsonValue);
                    p.expire(key, seconds);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean multiSetex(Map<String, String> kvMap, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (AssertUtil.isNotEmpty(kvMap)) {
                int index = 0;
                for (Map.Entry<String, String> entry : kvMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key, value})) continue;
                    p.set(key, value);
                    p.expire(key, seconds);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hmSet(String key, Map<String, String> map) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            if (map != null) {
                jedis.hmset(key, map);
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hmSetEx(String key, Map<String, String> map, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            if (map != null) {
                jedis.hmset(key, map);
                jedis.expire(key, seconds);
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hSetex(String key, String field, String value, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.hset(key, field, value);
            jedis.expire(key, seconds);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hgetAll(String key) {
        HashMap<String, String> ret = new HashMap();
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            ret = jedis.hgetAll(key);
        }
        catch (Exception e) {
            isBroken = true;
            e.printStackTrace();
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String filedList) {
        String ret = null;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            ret = jedis.hget(key, filedList);
        }
        catch (Exception e) {
            isBroken = true;
            e.printStackTrace();
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smember(String key) {
        HashSet<String> ret = new HashSet();
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            ret = jedis.smembers(key);
        }
        catch (Exception e) {
            isBroken = true;
            e.printStackTrace();
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expire(String key, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.expire(key, seconds);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            e.printStackTrace();
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hmsetexPipelined(Map<String, Map<String, String>> keyMapList, int seconds) {
        Jedis jedis = this.getJedis();
        boolean isBroken = false;
        try {
            Pipeline p = jedis.pipelined();
            if (keyMapList != null) {
                int index = 0;
                for (Map.Entry<String, Map<String, String>> entry : keyMapList.entrySet()) {
                    String key = entry.getKey();
                    Map<String, String> value = entry.getValue();
                    if (value == null) continue;
                    p.hmset(key, value);
                    p.expire(key, seconds);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hsetexPipelined(Map<String, String> keyMapList, int seconds) {
        Jedis jedis = this.getJedis();
        boolean isBroken = false;
        try {
            Pipeline p = jedis.pipelined();
            if (keyMapList != null) {
                for (Map.Entry<String, String> entry : keyMapList.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value == null) continue;
                    p.setex(key, seconds, value);
                }
            }
            p.sync();
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
    }

    public void returnResource(Jedis jedis, boolean isBroken) {
        try {
            if (null == jedis) {
                return;
            }
            jedis.close();
        }
        catch (Exception e) {
            System.out.println("redis error " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean multiSetex(String rowKey, String[] quailifer, long[] value, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (quailifer != null && value != null && quailifer.length == value.length) {
                int index = 0;
                for (int i = 0; i < quailifer.length; ++i) {
                    String key = rowKey + "_" + quailifer[i];
                    String val = Long.toString(value[i]);
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key, value})) continue;
                    p.set(key, val);
                    p.expire(key, seconds);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    public boolean multiDelete(String rowKey, Set<String> quailifer) {
        boolean result = false;
        if (quailifer != null) {
            ArrayList<String> idStr = new ArrayList<String>(quailifer);
            String[] indices = idStr.toArray(new String[idStr.size()]);
            result = this.multiDelete(rowKey, indices);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean multiDelete(String rowKey, String[] quailifer) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (quailifer != null) {
                int index = 0;
                for (int i = 0; i < quailifer.length; ++i) {
                    String key = rowKey + "_" + quailifer[i];
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key})) continue;
                    p.del(key);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sadd(String rowKey, String[] quailifer, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (quailifer != null) {
                int index = 0;
                for (int i = 0; i < quailifer.length; ++i) {
                    String value = quailifer[i];
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{value})) continue;
                    p.sadd(rowKey, new String[]{value});
                    if (++index % 1000 != 0) continue;
                    p.expire(rowKey, seconds);
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    public boolean srem(String rowKey, Set<String> quailifer) {
        boolean result = false;
        if (quailifer != null) {
            ArrayList<String> idStr = new ArrayList<String>(quailifer);
            String[] indices = idStr.toArray(new String[idStr.size()]);
            result = this.srem(rowKey, indices);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean srem(String rowKey, String[] quailifer) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (quailifer != null) {
                int index = 0;
                for (int i = 0; i < quailifer.length; ++i) {
                    String value = quailifer[i];
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{value})) continue;
                    p.srem(rowKey, new String[]{value});
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean multiIncrByex(String rowKey, String[] quailifer, long[] value, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (quailifer != null && value != null && quailifer.length == value.length) {
                int index = 0;
                for (int i = 0; i < quailifer.length; ++i) {
                    String key = rowKey + "_" + quailifer[i];
                    long val = value[i];
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key, value})) continue;
                    p.incrBy(key, val);
                    p.expire(key, seconds);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    public Map<String, String> multiGet(String rowKey, Set<String> quailifer) {
        Map<String, String> ret = new HashMap<String, String>();
        if (quailifer != null) {
            ArrayList<String> idStr = new ArrayList<String>(quailifer);
            String[] indices = idStr.toArray(new String[idStr.size()]);
            ret = this.multiGet(rowKey, indices);
        }
        return ret;
    }

    public Map<String, String> multiGetReturnBySubKey(String rowKey, Set<String> quailifer) {
        Map<String, String> ret = new HashMap<String, String>();
        if (quailifer != null) {
            ArrayList<String> idStr = new ArrayList<String>(quailifer);
            String[] indices = idStr.toArray(new String[idStr.size()]);
            ret = this.multiGetReturnBySubKey(rowKey, indices);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> multiGet(String rowKey, String[] quailifer) {
        HashMap<String, String> result = new HashMap<String, String>();
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (quailifer != null) {
                int index = 0;
                HashMap<String, Response> newMap = new HashMap<String, Response>();
                for (int i = 0; i < quailifer.length; ++i) {
                    String key = rowKey + "_" + quailifer[i];
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key})) continue;
                    newMap.put(key, p.get(key));
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                for (Map.Entry entry : newMap.entrySet()) {
                    Response sResponse = (Response)entry.getValue();
                    if (sResponse.get() == null) continue;
                    result.put((String)entry.getKey(), (String)sResponse.get());
                }
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> multiGetReturnBySubKey(String rowKey, String[] quailifer) {
        HashMap<String, String> result = new HashMap<String, String>();
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        HashMap<String, String> subKeyMap = new HashMap<String, String>();
        try {
            if (quailifer != null) {
                int index = 0;
                HashMap<String, Response> newMap = new HashMap<String, Response>();
                for (int i = 0; i < quailifer.length; ++i) {
                    String key = rowKey + "_" + quailifer[i];
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key})) continue;
                    subKeyMap.put(key, quailifer[i]);
                    newMap.put(key, p.get(key));
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                for (Map.Entry entry : newMap.entrySet()) {
                    Response sResponse = (Response)entry.getValue();
                    String subKey = (String)subKeyMap.get(entry.getKey());
                    if (subKey == null || sResponse == null) continue;
                    result.put(subKey, (String)sResponse.get());
                }
            }
        }
        catch (Exception e) {
            isBroken = true;
            e.printStackTrace();
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }
}

