/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.utils.mongodb;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.compute.biz.conf.MongoConfig;
import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import cn.com.duiba.nezha.compute.biz.utils.mongodb.MongoPoolUtil;
import com.alibaba.fastjson.JSON;
import com.mongodb.Block;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoClientUtil {
    private MongoConfig config;

    public MongoClientUtil(MongoConfig mongoConfig) {
        this.config = mongoConfig;
    }

    public MongoClient getClient() {
        MongoClient mongoClient = null;
        try {
            mongoClient = MongoPoolUtil.getInstance().getClient(this.config);
        }
        catch (Exception e) {
            System.out.println("mongoClient error " + e);
        }
        return mongoClient;
    }

    public MongoDatabase getDb(String dbName) {
        return this.getClient().getDatabase(dbName);
    }

    public MongoCollection<Document> getCollection(String dbName, String collectionName) {
        return this.getDb(dbName).getCollection(collectionName);
    }

    public MongoCollection<DBObject> getDBCollection(String dbName, String collectionName) {
        return this.getDb(dbName).getCollection(collectionName, DBObject.class);
    }

    public <T> List<T> find(Document filterDocument, Class<T> clazz, MongoCollection<Document> collection) {
        FindIterable iterable = collection.find((Bson)filterDocument, clazz);
        return this.parseFindIterable(iterable);
    }

    public <T> List<T> parseFindIterable(FindIterable<T> iterable) {
        final ArrayList ret = new ArrayList();
        if (iterable != null) {
            iterable.forEach(new Block<T>(){

                public void apply(T t) {
                    ret.add(t);
                }
            });
        }
        return ret;
    }

    public void insertOne(Document document, MongoCollection<Document> collection) {
        collection.insertOne((Object)document);
        System.out.println("\u6587\u6863\u63d2\u5165\u6210\u529f");
    }

    public void insertMany(List<Document> documents, MongoCollection<Document> collection) {
        collection.insertMany(documents);
        System.out.println("\u6587\u6863\u63d2\u5165\u6210\u529f");
    }

    public void bulkWriteInsert(List<Document> documents, MongoCollection<Document> collection) {
        ArrayList<InsertOneModel> requests = new ArrayList<InsertOneModel>();
        for (Document document : documents) {
            InsertOneModel iom = new InsertOneModel((Object)document);
            requests.add(iom);
        }
        BulkWriteResult bulkWriteResult = collection.bulkWrite(requests);
        System.out.println(bulkWriteResult.toString());
    }

    private void bulkWriteDelete(List<Document> documents, MongoCollection<Document> collection) {
        ArrayList<DeleteOneModel> requests = new ArrayList<DeleteOneModel>();
        for (Document document : documents) {
            Document queryDocument = new Document("_id", document.get((Object)"_id"));
            DeleteOneModel dom = new DeleteOneModel((Bson)queryDocument);
            requests.add(dom);
        }
        BulkWriteResult bulkWriteResult = collection.bulkWrite(requests);
    }

    public void bulkWriteUpdate(List<Document> documents, MongoCollection<Document> collection) {
        ArrayList<UpdateOneModel> requests = new ArrayList<UpdateOneModel>();
        for (Document document : documents) {
            Document queryDocument = new Document("_id", document.get((Object)"_id"));
            document.append(ProjectConstant.MD_CAT_INDEX, (Object)new Date());
            Document updateDocument = new Document("$set", (Object)document);
            UpdateOneModel uom = new UpdateOneModel((Bson)queryDocument, (Bson)updateDocument, new UpdateOptions().upsert(true));
            requests.add(uom);
        }
        BulkWriteResult bulkWriteResult = collection.bulkWrite(requests);
    }

    public void writeUpdate(Document document, MongoCollection<Document> collection) {
        ArrayList requests = new ArrayList();
        Document queryDocument = new Document("_id", document.get((Object)"_id"));
        document.append(ProjectConstant.MD_CAT_INDEX, (Object)new Date());
        Document updateDocument = new Document("$set", (Object)document);
        UpdateResult result = collection.updateOne((Bson)queryDocument, (Bson)updateDocument, new UpdateOptions().upsert(true));
    }

    public void bulkWriteUpdateString(String dbName, String collectionName, Map<String, String> map) {
        try {
            if (AssertUtil.isNotEmpty(map)) {
                ArrayList<Document> documents = new ArrayList<Document>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (!AssertUtil.isNotEmpty((String)value)) continue;
                    Document doc = Document.parse((String)value);
                    doc.append("_id", (Object)key);
                    documents.add(doc);
                }
                if (documents.size() > 0) {
                    this.bulkWriteUpdate(documents, this.getCollection(dbName, collectionName));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> void writeUpdateT2(String dbName, String collectionName, String key, T value) {
        try {
            if (AssertUtil.isNotEmpty(value)) {
                DBObject bson = (DBObject)com.mongodb.util.JSON.parse((String)JSON.toJSONString(value));
                bson.put("_id", (Object)key);
                this.getDBCollection(dbName, collectionName).replaceOne(Filters.eq((String)"_id", (Object)key), (Object)bson, new UpdateOptions().upsert(true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> void bulkWriteUpdateT(String dbName, String collectionName, Map<String, T> map) {
        try {
            if (AssertUtil.isNotEmpty(map)) {
                ArrayList<Document> documents = new ArrayList<Document>();
                for (Map.Entry<String, T> entry : map.entrySet()) {
                    String key = entry.getKey();
                    T valueT = entry.getValue();
                    String valueJson = JSON.toJSONString(valueT);
                    Document doc = Document.parse((String)valueJson);
                    doc.append("_id", (Object)key);
                    documents.add(doc);
                }
                if (documents.size() > 0) {
                    this.bulkWriteUpdate(documents, this.getCollection(dbName, collectionName));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> T findT(String dbName, String collectionName, String key, Class<T> clazz) {
        Object ret = null;
        try {
            if (AssertUtil.isNotEmpty((String)key)) {
                Document doc = new Document();
                doc.append("_id", (Object)key);
                List<Document> retTmp = this.find(doc, Document.class, this.getCollection(dbName, collectionName));
                if (AssertUtil.isNotEmpty(retTmp) && retTmp.get(0) != null) {
                    ret = JSON.parseObject((String)retTmp.get(0).toJson(), clazz);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)ret;
    }

    public void writeUpdateString(String dbName, String collectionName, String key, String jsonStr) {
        try {
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{key, jsonStr})) {
                Document doc = Document.parse((String)jsonStr);
                doc.append("_id", (Object)key);
                doc.append("key", (Object)key);
                this.writeUpdate(doc, this.getCollection(dbName, collectionName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> void writeUpdateT(String dbName, String collectionName, String key, T object) {
        try {
            String jsonStr = JSON.toJSONString(object);
            this.writeUpdateString(dbName, collectionName, key, jsonStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> Map<String, String> getMap(T t) {
        Map ret = null;
        String jString = JSON.toJSONString(t);
        ret = (Map)JSON.parse((String)jString);
        return ret;
    }

    public static <T> String getMapString(T t) {
        return JSON.toJSONString(t);
    }

    public static Document buildDocument(Object obj, Class clazz) {
        Field[] fields;
        Document document = new Document();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.getType().isAssignableFrom(List.class) || field.getType().isAssignableFrom(Collection.class) || field.getType().isAssignableFrom(Map.class) ? JSON.toJSONString((Object)field.get(obj)) : field.get(obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (value == null) continue;
            document.append(field.getName(), value);
        }
        return document;
    }
}

