/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.utils.mongodb;

import cn.com.duiba.nezha.compute.biz.conf.MongoConfig;
import cn.com.duiba.nezha.compute.core.util.MyStringUtil2;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MongoPoolUtil {
    private static Map<String, MongoClient> maps = new HashMap<String, MongoClient>();

    private MongoPoolUtil() {
    }

    public static MongoPoolUtil getInstance() {
        return MongoPoolHolder.instance;
    }

    public static MongoClient getPool(MongoConfig mongoConfig) {
        MongoClient mongoClient = null;
        String ip = mongoConfig.getIp();
        int port = mongoConfig.getPort();
        String passWord = mongoConfig.getPassWord();
        String userName = mongoConfig.getUserName();
        String databaseName = mongoConfig.getDatabaseName();
        String key = ip + ":" + databaseName;
        if (!maps.containsKey(key)) {
            List<ServerAddress> addrs = MongoPoolUtil.getAddressList(ip);
            MongoCredential credential = MongoCredential.createScramSha1Credential((String)userName, (String)databaseName, (char[])passWord.toCharArray());
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
            credentials.add(credential);
            MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
            builder.connectionsPerHost(10);
            builder.connectTimeout(3000);
            builder.maxWaitTime(3000);
            builder.socketTimeout(3000);
            builder.socketKeepAlive(true);
            MongoClientOptions myOptions = builder.build();
            mongoClient = new MongoClient(addrs, credentials, myOptions);
            maps.put(key, mongoClient);
            System.out.println("put new pool");
        } else {
            mongoClient = maps.get(key);
        }
        return mongoClient;
    }

    public MongoClient getClient(MongoConfig mongoConfig) {
        MongoClient mongoClient = null;
        int count = 0;
        do {
            try {
                mongoClient = MongoPoolUtil.getPool(mongoConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
                MongoPoolUtil.getPool(mongoConfig);
            }
        } while (mongoClient == null && count < 4);
        return mongoClient;
    }

    public static List<ServerAddress> getAddressList(String hostsStr, int port) {
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
        try {
            List hostList;
            if (hostsStr != null && (hostList = MyStringUtil2.stringToList((String)hostsStr, (String)",")) != null) {
                for (String host : hostList) {
                    ServerAddress serverAddress = new ServerAddress(host, port);
                    addrs.add(serverAddress);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addrs;
    }

    public static List<ServerAddress> getAddressList(String hostsStr) {
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
        try {
            List hostStrList;
            if (hostsStr != null && (hostStrList = MyStringUtil2.stringToList((String)hostsStr, (String)",")) != null) {
                for (String hostStr : hostStrList) {
                    List node = MyStringUtil2.stringToList((String)hostStr, (String)":");
                    if (node == null || node.size() != 2) continue;
                    addrs.add(new ServerAddress((String)node.get(0), Integer.valueOf((String)node.get(1)).intValue()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addrs;
    }

    private static class MongoPoolHolder {
        private static final MongoPoolUtil instance = new MongoPoolUtil();

        private MongoPoolHolder() {
        }
    }
}

