package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.req.ReqAppStatistics;
import cn.com.duiba.tuia.pangea.center.api.req.ReqReportByPage;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayReportRsp;

import java.util.List;

/**
 * ClassName: RemoteDayReportService <br/>
 * Function: 活动测试数据相关. <br/>
 * date: 2019年9月2日 下午3:02:09 <br/>
 *
 * @author scd
 * @version
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteDayReportService {

    /**
     * 分页活动日数据列表
     * @param reqReportByPage
     * @return
     */
    List<DayReportRsp> selectDayReport(ReqReportByPage reqReportByPage);

    /**
     * 获取所有活动数
     * @param reqReportByPage
     * @return
     */
    Integer selectDayReportCount(ReqReportByPage reqReportByPage);

    /**
     * 获取所有测试广告位id
     * @param req
     * @return
     */
    List<Long> getSlotIds(ReqAppStatistics req);

    /**
     * 根据广告位id获取数据
     * @param req
     * @return
     */
    List<DayReportRsp> selectAppData(ReqAppStatistics req);

}
