package cn.com.duiba.tuia.pangea.center.api.req.flowmanager;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-09-06 12:58
 */
@Data
public class ReqOperateShieldDto implements Serializable {

    private static final long serialVersionUID = 91777783199865422L;

    private Byte operateType;

    private String operateValue;

    private List<Long> valueList;

    public void setValueList(final String operateValue, final List<Long> valueList) {
        final List<Long> list = Arrays.stream(StringUtils.split(operateValue, ",")).map(
                Long::valueOf).collect(Collectors.toList());
        if (Objects.isNull(valueList)) {
            this.valueList = list;
        } else {
            valueList.addAll(list);
        }
    }
}
