package cn.com.duiba.tuia.pangea.center.api.req.flowmanager;

import cn.com.duiba.tuia.pangea.center.api.constant.FlowTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 大盘流量和流量比
 * @author yuantong
 * @version 1.0
 * @since 2019-09-06 13:15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ReqWholeOrSlotRatioDto implements Serializable {


    private static final long serialVersionUID = 91777783199865422L;

    /**
     * 广告位Id
     */
    private Long slotId;

    /**
     * 分流类型 FlowTypeEnum
     */
    private Integer flowType;

    /**
     * 比例
     */
    private Integer ratio;

    private boolean isExistSlotId() {
        return this.flowType.equals(FlowTypeEnum.TYPE_SLOT.getCode());
    }

}