/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.caller.CallerUtil;
import cn.hutool.log.GlobalLogFactory;
import cn.hutool.log.Log;
import cn.hutool.log.dialect.commons.ApacheCommonsLogFactory;
import cn.hutool.log.dialect.console.ConsoleLogFactory;
import cn.hutool.log.dialect.jdk.JdkLogFactory;
import cn.hutool.log.dialect.log4j.Log4jLogFactory;
import cn.hutool.log.dialect.log4j2.Log4j2LogFactory;
import cn.hutool.log.dialect.slf4j.Slf4jLogFactory;
import cn.hutool.log.dialect.tinylog.TinyLogFactory;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LogFactory {
    protected String logFramworkName;
    private Map<Object, Log> logCache;

    public LogFactory(String logFramworkName) {
        this.logFramworkName = logFramworkName;
        this.logCache = new ConcurrentHashMap<Object, Log>();
    }

    public Log getLog(String name) {
        Log log = this.logCache.get(name);
        if (null == log) {
            log = this.createLog(name);
            this.logCache.put(name, log);
        }
        return log;
    }

    public Log getLog(Class<?> clazz) {
        Log log = this.logCache.get(clazz);
        if (null == log) {
            log = this.createLog(clazz);
            this.logCache.put(clazz, log);
        }
        return log;
    }

    public abstract Log createLog(String var1);

    public abstract Log createLog(Class<?> var1);

    protected void checkLogExist(Object logClassName) {
    }

    public static LogFactory getCurrentLogFactory() {
        return GlobalLogFactory.get();
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        return GlobalLogFactory.set(logFactoryClass);
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        return GlobalLogFactory.set(logFactory);
    }

    public static Log get(String name) {
        return LogFactory.getCurrentLogFactory().getLog(name);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.getCurrentLogFactory().getLog(clazz);
    }

    public static Log get() {
        return LogFactory.get(CallerUtil.getCallerCaller());
    }

    public static LogFactory create() {
        LogFactory factory = LogFactory.doCreate();
        factory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", factory.logFramworkName);
        return factory;
    }

    private static LogFactory doCreate() {
        try {
            return new Slf4jLogFactory(true);
        }
        catch (NoClassDefFoundError e) {
            try {
                return new Log4j2LogFactory();
            }
            catch (NoClassDefFoundError e2) {
                try {
                    return new Log4jLogFactory();
                }
                catch (NoClassDefFoundError e3) {
                    try {
                        return new ApacheCommonsLogFactory();
                    }
                    catch (NoClassDefFoundError e4) {
                        try {
                            return new TinyLogFactory();
                        }
                        catch (NoClassDefFoundError e5) {
                            URL url = ResourceUtil.getResource("logging.properties");
                            return null != url ? new JdkLogFactory() : new ConsoleLogFactory();
                        }
                    }
                }
            }
        }
    }
}

