package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.req.PlanInsertReq;
import cn.com.duiba.tuia.pangea.center.api.req.flowmanager.ReqFlowBaseByPageDto;
import cn.com.duiba.tuia.pangea.center.api.req.newactivity.NewActivityTestAddOrUpdateReq;
import cn.com.duiba.tuia.pangea.center.api.rsp.newactivity.SelectSlotAccessUvRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.newactivity.SlotTestRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 新活动测试相关服务
 * @author miaohongshuai
*/
@AdvancedFeignClient
public interface RemoteNewActivityTestService {

    /**
     * 基础信息下一步校验
     * @param req
     * @return
     */
    DubboResult<Boolean> next(PlanInsertReq req);

    /**
     * 广告位选择--列表查询
     * @param req
     * @return
     */
    PageResultDto<SlotTestRsp> slotList(ReqFlowBaseByPageDto req);

    /**
     * 获取可测试的广告位id列表
     * @return
     */
    List<Long> getAllSlotIds();

    /**
     * 广告位选择确认--已选广告位的测试流量总计
     * @param slotIds
     * @return
     */
    SelectSlotAccessUvRsp getSlotCount(List<Long> slotIds);

    /**
     * 确认测试信息--测试组信息保存活动更新接口
     * @param req
     * @return
     */
    Long addOrUpdateTestActivity(NewActivityTestAddOrUpdateReq req);
}
