package cn.com.duiba.tuia.pangea.center.api.dto.fuse;

import com.google.common.base.Objects;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 熔断查询内容 提供给大数据的接口的数据结构
 * @author yuantong
 * @version 1.0
 * @since 2019-11-16 09:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PgFuseResourceDto implements Serializable {

    private static final long serialVersionUID = 3070939046156494326L;

    private Long planId;
    private Long slotId;
    //对照组id
    private Long activityId;
    private Integer groupTag;

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final PgFuseResourceDto that = (PgFuseResourceDto) o;
        return Objects.equal(planId, that.planId) &&
                Objects.equal(slotId, that.slotId) &&
                Objects.equal(activityId, that.activityId) &&
                Objects.equal(groupTag, that.groupTag);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(planId, slotId, activityId, groupTag);
    }
}
