/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.aop.interceptor;

import cn.hutool.aop.aspects.Aspect;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JdkInterceptor
implements InvocationHandler {
    private Object target;
    private Aspect aspect;

    public JdkInterceptor(Object target, Aspect aspect) {
        this.target = target;
        this.aspect = aspect;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object target = this.target;
        Aspect aspect = this.aspect;
        Object result = null;
        if (aspect.before(target, method, args)) {
            try {
                result = ReflectUtil.invoke(target, method, args);
            }
            catch (UtilException e) {
                Throwable cause = e.getCause();
                if (e.getCause() instanceof InvocationTargetException) {
                    aspect.afterException(target, method, args, ((InvocationTargetException)cause).getTargetException());
                }
                throw e;
            }
        }
        if (aspect.after(target, method, args)) {
            return result;
        }
        return null;
    }
}

