/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.pangea.center.api.utils;

import cn.com.duiba.tuia.pangea.center.api.dto.dayu.SceneConfig;
import cn.com.duiba.tuia.pangea.center.api.enums.ArgumentType;
import cn.com.duiba.tuia.pangea.center.api.enums.ConfigTypeEnum;
import cn.com.duiba.tuia.pangea.center.api.enums.DiversionTypeEnum;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayuResult;
import cn.com.duiba.tuia.pangea.center.api.utils.HashAlgorithm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneUtils {
    private static final Logger log = LoggerFactory.getLogger(SceneUtils.class);

    private SceneUtils() {
    }

    public static DayuResult resolve(SceneConfig sceneConfig, Map<ArgumentType, Object> params) {
        return SceneUtils.getDayuResult(sceneConfig, params);
    }

    private static DayuResult getDayuResult(SceneConfig sceneConfig, Map<ArgumentType, Object> params) {
        DayuResult result = new DayuResult();
        result.setArguments(new HashMap<String, String>());
        result.setExpIds(new ArrayList<Long>());
        SceneUtils.getExpIdsAndArguments(sceneConfig, null, params, result, 0);
        result.setExpIds(result.getExpIds().stream().sorted().collect(Collectors.toList()));
        return result;
    }

    private static void getExpIdsAndArguments(SceneConfig sceneConfig, String parentType, Map<ArgumentType, Object> params, DayuResult result, Integer hash) {
        if (sceneConfig == null) {
            return;
        }
        List<SceneConfig> configList = sceneConfig.getConfigList();
        if (!sceneConfig.getType().equals(ConfigTypeEnum.EXPERIMENT.getType()) && CollectionUtils.isEmpty(configList)) {
            return;
        }
        if (parentType == null) {
            configList.forEach(config -> SceneUtils.getExpIdsAndArguments(config, sceneConfig.getType(), params, result, 100));
        } else if (parentType.equals(ConfigTypeEnum.DOMAIN.getType())) {
            Integer finalHash = SceneUtils.calculateHash(params, sceneConfig.getDiversion(), sceneConfig.getName());
            configList.forEach(config -> SceneUtils.getExpIdsAndArguments(config, sceneConfig.getType(), params, result, finalHash));
        } else if (sceneConfig.getType().equals(ConfigTypeEnum.DOMAIN.getType()) && SceneUtils.doesHit(sceneConfig.getFlowRate(), hash)) {
            configList.forEach(config -> SceneUtils.getExpIdsAndArguments(config, sceneConfig.getType(), params, result, hash));
        } else if (SceneUtils.doesHit(sceneConfig.getFlowRate(), hash)) {
            Long id = sceneConfig.getId();
            result.getExpIds().add(id);
            result.getArguments().putAll(sceneConfig.getArguments());
        }
    }

    public static void main(String[] args) {
        String deviceId = "3fff8fea-a26e-4dd6-a58d-c0199339e97f";
        HashMap<ArgumentType, Object> params = new HashMap<ArgumentType, Object>(2);
        params.put(ArgumentType.DEVICE_ID, deviceId);
        Integer finalHash = SceneUtils.calculateHash(params, 2, "\u5c42\u54cd\u5e94\u5f0f\u63d2\u4ef6ABTest_267_283000_12954");
        Integer finalHashOpen = SceneUtils.calculateHash(params, 2, "\u8d44\u6e90\u6d4b\u8bd5\u662f\u5426\u6d4b\u8bd5\u5206\u6d41\u5c42\uff0c\u5e7f\u544a\u4f4d283000\u6d3b\u52a812954");
        System.out.println("finalHash=" + finalHash + ", finalHashOpen=" + finalHashOpen);
    }

    private static boolean doesHit(String flow, Integer number) {
        if (!flow.contains(",")) {
            return true;
        }
        Integer start = Integer.parseInt(flow.split(",")[0]);
        Integer end = Integer.parseInt(flow.split(",")[1]);
        return number >= start && number <= end;
    }

    private static int calculateHash(Map<ArgumentType, Object> params, Integer hashType, String layerName) {
        int hash;
        if (hashType.equals(DiversionTypeEnum.CONSUMER_ID_HASH.getType())) {
            Long consumerId = (Long)params.get((Object)ArgumentType.CONSUMER_ID);
            hash = HashAlgorithm.dekHash(consumerId.toString() + layerName);
        } else if (hashType.equals(DiversionTypeEnum.DEVICE_ID_HASH.getType())) {
            String deviceId = (String)params.get((Object)ArgumentType.DEVICE_ID);
            hash = HashAlgorithm.apHash(deviceId + layerName);
        } else {
            hash = new Random().nextInt(100);
        }
        return (hash < 0 ? -hash : hash) % 100 + 1;
    }
}

