package cn.com.duiba.tuia.pangea.center.api.dto.spread;

import cn.com.duiba.tuia.pangea.center.api.constant.SpreadFlowTypeEnum;
import cn.com.duiba.tuia.pangea.center.api.dto.BaseDto;
import cn.com.duiba.tuia.pangea.center.api.req.BaseQueryReq;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

@Data
public class SpreadActivityDTO extends BaseQueryReq{

    private Long id;

    /**
     *  铺量计划id
     */
    private Long spreadId;

    /**
     *  媒体id
     */
    private Long appId;

    /**
     *  媒体名
     */
    private String appName;

    /**
     *  广告位id
     */
    private Long slotId;

    /**
     *  广告位名
     */
    private String slotName;

    /**
     *  老活动id
     */
    private Long oldActivityId;

    /**
     *  老活动量级
     */
    private Integer oldActivityNumber;

    /**
     *  新活动id
     */
    private Long newActivityId;

    /**
     *  新活动量级
     */
    private Integer newActivityNumber;

    /**
     *  流量类型  {@link SpreadFlowTypeEnum}
     */
    private Integer flowType;

    /**
     *  铺量占比
     */
    private Integer spreadRatio;


    /**
     *  分组标签
     */
    private Integer groupTag;

    /**
     *  运营
     */
    private String mediaOperate;

    private Date gmtCreate;

    private Date gmtModified;

    //---------------查询条件-------------
    private Set<Long> slotIds;
}
