/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi;

import cn.hutool.core.exceptions.DependencyException;
import cn.hutool.core.util.ClassLoaderUtil;

public class PoiChecker {
    public static void checkPoiImport() {
        try {
            Class.forName("org.apache.poi.ss.usermodel.Workbook", false, ClassLoaderUtil.getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new DependencyException(e, "You need to add POI dependency 'poi-ooxml' to your project, and version >= 3.17", new Object[0]);
        }
    }

    public static DependencyException transError(NoClassDefFoundError e) {
        switch (e.getMessage()) {
            case "org/apache/poi/ss/usermodel/Workbook": {
                return new DependencyException(e, "You need to add POI dependency 'poi-ooxml' to your project, and version >= 3.17", new Object[0]);
            }
            case "org/apache/poi/poifs/filesystem/FileMagic": {
                return new DependencyException(e, "You need to add POI dependency 'poi-ooxml' to your project, and version >= 3.17", new Object[0]);
            }
        }
        return new DependencyException(e);
    }
}

