/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentUtils.class);

    private ConcurrentUtils() {
    }

    public static void executeTasksBlocking(Executor executor, List<Runnable> runnables) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(runnables.size());
        for (Runnable r : runnables) {
            executor.execute(() -> {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    public static <V> List<V> submitTasksBlocking(Executor executor, List<Callable<V>> callables) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(callables.size());
        ConcurrentHashMap seq2valueMap = new ConcurrentHashMap();
        int i = 0;
        for (Callable r : callables) {
            int j = i++;
            executor.execute(() -> {
                try {
                    Object v = r.call();
                    seq2valueMap.put(j, v);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        ArrayList ret = new ArrayList(i);
        for (int k = 0; k < i; ++k) {
            ret.add(seq2valueMap.get(k));
        }
        return ret;
    }
}

