package cn.com.duiba.tuia.pangea.center.api.dto.spread;

import cn.com.duiba.tuia.pangea.center.api.constant.SpreadStatusEnum;
import cn.com.duiba.tuia.pangea.center.api.req.BaseQueryReq;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class SpreadDTO extends BaseQueryReq {

    private Long id;

    private Long uploadLogId;

    /**
     *  铺量计划名
     */
    private String spreadPlanName;

    /**
     *  老活动数量
     */
    private Integer oldActivityNumber;

    /**
     *  新活动数量
     */
    private Integer newActivityNumber;

    /**
     *  负责人
     */
    private String admin;

    /**
     *  开始时间
     */
    private Date startTime;

    /**
     *  结束时间
     */
    private Date endTime;

    /**
     *  盘古测试id
     */
    private Long pgTestPlanId;

    /**
     *  前期测试结论
     */
    private String testResult;


    /**
     *  状态 {@link  SpreadStatusEnum}
     */
    private Integer status;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date gmtCreate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date gmtModified;

    private Long adminId;

    /**
     *  铺量活动列表
     */
    private List<SpreadActivityDTO> listSpreadActivity;
}
