package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.req.ReqAppStatistics;
import cn.com.duiba.tuia.pangea.center.api.req.ReqReportByPage;
import cn.com.duiba.tuia.pangea.center.api.req.ReqResourceExportStatistics;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.BuoyAppReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.BuoyReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayAppReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayReportRspList;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.InterceptAppReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.InterceptReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.LayerAppReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.LayerReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.PluginAppReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.PluginReportRsp;

import java.util.List;

/**
 * ClassName: RemoteDayReportService <br/>
 * Function: 活动测试数据相关. <br/>
 * date: 2019年9月2日 下午3:02:09 <br/>
 *
 * @author scd
 * @version
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteDayReportService {

    /**
     * 分页活动日数据列表
     * @param reqReportByPage
     * @return
     */
    List<DayReportRsp> selectDayReport(ReqReportByPage reqReportByPage);

    /**
     * 获取所有测试广告位id
     * @param req
     * @return
     */
    List<Long> getSlotIds(ReqAppStatistics req);


    /**
     * 获取分页列表
     * @param req
     * @return
     */
    PageResultDto<DayAppReportRsp> selectAppData(ReqAppStatistics req);

    /**
     * 获取分页列表
     * @param req
     * @return
     */
    PageResultDto<DayAppReportRsp> selectAppDataV1(ReqAppStatistics req);


    List<DayReportRsp> selectDayReportData(ReqReportByPage reqReportByPage);

    List<DayReportRsp> selectDayReportDataV1(ReqAppStatistics req);

    List<DayReportRsp> selectReportDataV1(ReqAppStatistics req);

    PageResultDto<DayReportRspList> selectDayReportListNew(ReqReportByPage req);


    //下拉/浮标 依次是大盘的每日数据、总数据  和 媒体的每日数据、总数据
    List<BuoyReportRsp> selectDayBuoyData(ReqResourceExportStatistics req);

    List<BuoyReportRsp> selectBuoyData(ReqResourceExportStatistics req);

    List<BuoyAppReportRsp> selectAppDayBuoyData(ReqResourceExportStatistics req);

    List<BuoyAppReportRsp> selectAppBuoyData(ReqResourceExportStatistics req);



    //返回式拦截 依次是大盘的每日数据、总数据  和 媒体的每日数据、总数据
    List<InterceptReportRsp> selectDayInterceptData(ReqResourceExportStatistics req);

    List<InterceptReportRsp> selectInterceptData(ReqResourceExportStatistics req);

    List<InterceptAppReportRsp> selectAppDayInterceptData(ReqResourceExportStatistics req);

    List<InterceptAppReportRsp> selectAppInterceptData(ReqResourceExportStatistics req);


    //弹层 依次是大盘的每日数据、总数据  和 媒体的每日数据、总数据
    List<LayerReportRsp> selectDayLayerData(ReqResourceExportStatistics req);

    List<LayerReportRsp> selectLayerData(ReqResourceExportStatistics req);

    List<LayerAppReportRsp> selectAppDayLayerData(ReqResourceExportStatistics req);

    List<LayerAppReportRsp> selectAppLayerData(ReqResourceExportStatistics req);


    //插件 依次是大盘的每日数据、总数据  和 媒体的每日数据、总数据
    List<PluginReportRsp> selectDayPluginData(ReqResourceExportStatistics req);

    List<PluginReportRsp> selectPluginData(ReqResourceExportStatistics req);

    List<PluginAppReportRsp> selectAppDayPluginData(ReqResourceExportStatistics req);

    List<PluginAppReportRsp> selectAppPluginData(ReqResourceExportStatistics req);


}
