package cn.com.duiba.tuia.pangea.center.api.rsp;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by scd on 2019/09/02.
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DayReportRsp implements Serializable {

    private static final long serialVersionUID = 3809868989939784143L;

    private Long appId;
    private String appName;
    private Long slotId;//广告位id
    private String slotName;
    private Integer id;
    private Integer activityPrcent;//百分比
    private Long activityId; //活动id
    private String curDateString;
    private String activityTypeString;//类型
    private Long actRequestPv;//活动请求PV
    private Long actRequestUv;//活动请求uv
    private Long actJoinUv;//活动参与uv
    private Long actJoinPv;//活动参与pv
    private String actParticipateRateString;//参与率
    private Float rptParticipateCount;//'复参数'
    private Long advertRequestPv;//券请求pv
    private Long advertRequestCount;//发券量
    private String advertSuccessRateString;//发券成功率
    private Long advertShowCount;//券曝光
    private String requestSuccessRateString;//券曝光成功率
    private Long advertClickCount;//券有效点击
    private Float ctr;//ctr
    private Float adConsumeDouble;//消耗
    private Float actPerUvClickCount;//每uv参与
    private Float actPerUvLaunchCount;//每uv发券
    private Float actPerUvClickLaunchCount;//每uv券点击
    private Float actPerUvConsume;//每uv收益
    private Long formFeeClick;//表单类计费点击
    private Long formLandPv;//表单类落地页访问PV
    private Float formAdvertCvr;//表单类广告CvR
    private Long formLandInnerPv;//表单类落地页转化PV
    private Float cvr;//cvr


    //数据模块
    private String curDate;
    private String curDate2;
    private Boolean showButton;//前端是否显控制按钮

    private Long activitySource;//活动对应对照id
    private Integer groupTag;//分组标记
    private Integer activityStatus;//状态
    private Integer planStatus;//计划状态
    private Integer activityType;//类型
    private Float actParticipateRate;//参与率
    private Float advertSuccessRate;//发券成功率
    private Float requestSuccessRate;//券曝光成功率
    private Long adConsume;//消耗
    private Integer groupType;//1为对照组 2为测试组

    //测试组组装
    private List<Long> activityIds;
    private List<Integer> activityTypes;
    private List<Integer> activityStatuss;
    private List<Integer> activityPrcents;
    private List<Long> activitySources;

    private List<Long> actRequestPvs;
    private List<Long> actRequestUvs;
    private List<Long> actJoinUvs;
    private List<Long> actJoinPvs;
    private List<Float> rptParticipateCounts;
    private List<Long> advertRequestPvs;
    private List<Long> advertRequestCounts;
    private List<Long> advertShowCounts;
    private List<Long> advertClickCounts;
    private List<Float> ctrs;
    private List<Float> actPerUvClickCounts;
    private List<Float> actPerUvLaunchCounts;
    private List<Float> actPerUvClickLaunchCounts;
    private List<Float> actPerUvConsumes;
    private List<Long> formFeeClicks;
    private List<Long> formLandPvs;
    private List<Float> formAdvertCvrs;
    private List<Long> formLandInnerPvs;
    private List<Float> cvrs;
    private List<Float> actParticipateRates;
    private List<Float> requestSuccessRates;
    private List<Long> adConsumes;
    private List<Float> advertSuccessRates;
    private Boolean nullCheck;
    private Integer testNullCheck;

    @SuppressWarnings("squid:S3776")
    public void setList(DayReportRsp reportRsp){

        if(CollectionUtils.isEmpty( reportRsp.getActRequestPvs())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActRequestPv());
            reportRsp.setActRequestPvs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActRequestUvs())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActRequestUv());
            reportRsp.setActRequestUvs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActJoinUvs())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActJoinUv());
            reportRsp.setActJoinUvs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActJoinPvs())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActJoinPv());
            reportRsp.setActJoinPvs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getRptParticipateCounts())){
            List<Float> floats = new ArrayList<>();
            floats.add(reportRsp.getRptParticipateCount());
            reportRsp.setRptParticipateCounts(floats);
        }

        if(CollectionUtils.isEmpty(reportRsp.getAdvertRequestPvs())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertRequestPv());
            reportRsp.setAdvertRequestPvs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getAdvertRequestCounts())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertRequestCount());
            reportRsp.setAdvertRequestCounts(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getAdvertShowCounts())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertShowCount());
            reportRsp.setAdvertShowCounts(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getAdvertClickCounts())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertClickCount());
            reportRsp.setAdvertClickCounts(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getCtrs())){
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getCtr());
            reportRsp.setCtrs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActPerUvClickCounts())){
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActPerUvClickCount());
            reportRsp.setActPerUvClickCounts(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActPerUvLaunchCounts())){
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActPerUvLaunchCount());
            reportRsp.setActPerUvLaunchCounts(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActPerUvClickLaunchCounts())){
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActPerUvClickLaunchCount());
            reportRsp.setActPerUvClickLaunchCounts(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActPerUvConsumes())){
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActPerUvConsume());
            reportRsp.setActPerUvConsumes(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getFormFeeClicks())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getFormFeeClick());
            reportRsp.setFormFeeClicks(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getFormLandPvs())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getFormLandPv());
            reportRsp.setFormLandPvs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getFormAdvertCvrs())){
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getFormAdvertCvr());
            reportRsp.setFormAdvertCvrs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getFormLandInnerPvs())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getFormLandInnerPv());
            reportRsp.setFormLandInnerPvs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getCvrs())){
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getCvr());
            reportRsp.setCvrs(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActivityIds())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActivityId());
            reportRsp.setActivityIds(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActivityStatuss())){
            List<Integer> longs = new ArrayList<>();
            longs.add(reportRsp.getActivityStatus());
            reportRsp.setActivityStatuss(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActivityTypes())){
            List<Integer> longs = new ArrayList<>();
            longs.add(reportRsp.getActivityType());
            reportRsp.setActivityTypes(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getActivitySources())){
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActivitySource());
            reportRsp.setActivitySources(longs);
        }

        if(CollectionUtils.isEmpty(reportRsp.getAdvertSuccessRates())){
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertSuccessRate());
            reportRsp.setAdvertSuccessRates(longs);
        }


    }



}
