/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(size);
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(int size) {
        return new HashSet(size);
    }

    public static <T> HashSet<T> newHashSet(Collection<? extends T> c) {
        return new HashSet<T>(c);
    }

    public static <T> HashSet<T> newHashSet(Collection<? extends T> s1, Collection<? extends T> s2) {
        HashSet<T> set = CollectionHelper.newHashSet(s1);
        set.addAll(s2);
        return set;
    }

    public static <T> HashSet<T> newHashSet(Iterable<? extends T> iterable) {
        HashSet<T> set = CollectionHelper.newHashSet();
        for (T t : iterable) {
            set.add(t);
        }
        return set;
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(int size) {
        return new ArrayList(size);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> ... iterables) {
        ArrayList<T> resultList = CollectionHelper.newArrayList();
        for (Iterable<T> oneIterable : iterables) {
            for (T oneElement : oneIterable) {
                resultList.add(oneElement);
            }
        }
        return resultList;
    }

    public static <T> Set<T> asSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }

    public static <K, V> Map<K, List<V>> partition(List<V> list, Partitioner<K, V> partitioner) {
        if (list == null) {
            return Collections.emptyMap();
        }
        HashMap theValue = CollectionHelper.newHashMap();
        for (V v : list) {
            K key = partitioner.getPartition(v);
            ArrayList partition = (ArrayList)theValue.get(key);
            if (partition == null) {
                partition = CollectionHelper.newArrayList();
                theValue.put(key, partition);
            }
            partition.add(v);
        }
        return theValue;
    }

    public static <K, V> Map<K, Set<V>> partition(Set<V> set, Partitioner<K, V> partitioner) {
        if (set == null) {
            return Collections.emptyMap();
        }
        HashMap theValue = CollectionHelper.newHashMap();
        for (V v : set) {
            K key = partitioner.getPartition(v);
            HashSet partition = (HashSet)theValue.get(key);
            if (partition == null) {
                partition = CollectionHelper.newHashSet();
                theValue.put(key, partition);
            }
            partition.add(v);
        }
        return theValue;
    }

    public static interface Partitioner<K, V> {
        public K getPartition(V var1);
    }
}

