/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ObjectVendorExtension;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class VendorExtensionsReader
implements OperationBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(VendorExtensionsReader.class);

    public void apply(OperationContext context) {
        Optional apiOperation = context.findAnnotation(ApiOperation.class);
        if (apiOperation.isPresent()) {
            Extension[] extensionsAnnotations = ((ApiOperation)apiOperation.get()).extensions();
            List<VendorExtension> extensions = this.readExtensions(extensionsAnnotations);
            LOG.debug("Extension count {} for method {}", (Object)extensions.size(), (Object)context.getName());
            context.operationBuilder().extensions(extensions);
        }
    }

    private List<VendorExtension> readExtensions(Extension[] vendorAnnotations) {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])vendorAnnotations)).transform(this.toVendorExtension()).toList();
    }

    private Function<Extension, VendorExtension> toVendorExtension() {
        return new Function<Extension, VendorExtension>(){

            public VendorExtension apply(Extension input) {
                return (VendorExtension)Optional.fromNullable((Object)Strings.emptyToNull((String)input.name())).transform(VendorExtensionsReader.this.propertyExtension(input)).or((Object)VendorExtensionsReader.this.objectExtension(input));
            }
        };
    }

    private VendorExtension objectExtension(Extension each) {
        ObjectVendorExtension extension = new ObjectVendorExtension(this.ensurePrefixed(Strings.nullToEmpty((String)each.name())));
        for (ExtensionProperty property : each.properties()) {
            if (Strings.isNullOrEmpty((String)property.name()) || Strings.isNullOrEmpty((String)property.value())) continue;
            extension.addProperty((VendorExtension)new StringVendorExtension(property.name(), property.value()));
        }
        return extension;
    }

    private Function<String, VendorExtension> propertyExtension(final Extension annotation) {
        return new Function<String, VendorExtension>(){

            public VendorExtension apply(String input) {
                ObjectVendorExtension extension = new ObjectVendorExtension(VendorExtensionsReader.this.ensurePrefixed(input));
                for (ExtensionProperty each : annotation.properties()) {
                    extension.addProperty((VendorExtension)new StringVendorExtension(each.name(), each.value()));
                }
                return extension;
            }
        };
    }

    private String ensurePrefixed(String name) {
        if (!Strings.isNullOrEmpty((String)name) && !name.startsWith("x-")) {
            return "x-" + name;
        }
        return name;
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

