/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.compiler.BytecodeDisassembler;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.Compiler;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.debug.EvalExprEvent;
import org.stringtemplate.v4.debug.EvalTemplateEvent;
import org.stringtemplate.v4.debug.IndentEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.misc.ArrayIterator;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STNoSuchAttributeException;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

public class Interpreter {
    public static final int DEFAULT_OPERAND_STACK_SIZE = 100;
    public static final Set<String> predefinedAnonSubtemplateAttributes = new HashSet<String>(){
        {
            this.add("i");
            this.add("i0");
        }
    };
    Object[] operands = new Object[100];
    int sp = -1;
    int current_ip = 0;
    int nwline = 0;
    public InstanceScope currentScope = null;
    STGroup group;
    Locale locale;
    ErrorManager errMgr;
    public static boolean trace = false;
    protected List<String> executeTrace;
    public boolean debug = false;
    protected List<InterpEvent> events;

    public Interpreter(STGroup group, boolean debug) {
        this(group, Locale.getDefault(), group.errMgr, debug);
    }

    public Interpreter(STGroup group, Locale locale, boolean debug) {
        this(group, locale, group.errMgr, debug);
    }

    public Interpreter(STGroup group, ErrorManager errMgr, boolean debug) {
        this(group, Locale.getDefault(), errMgr, debug);
    }

    public Interpreter(STGroup group, Locale locale, ErrorManager errMgr, boolean debug) {
        this.group = group;
        this.locale = locale;
        this.errMgr = errMgr;
        this.debug = debug;
        if (debug) {
            this.events = new ArrayList<InterpEvent>();
            this.executeTrace = new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(STWriter out, ST self) {
        this.pushScope(self);
        try {
            this.setDefaultArguments(out, self);
            int n = this._exec(out, self);
            return n;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.INTERNAL_ERROR, "internal error: " + sw.toString());
            int n = 0;
            return n;
        }
        finally {
            this.popScope();
        }
    }

    protected int _exec(STWriter out, ST self) {
        int start = out.index();
        short prevOpcode = 0;
        int n = 0;
        byte[] code = self.impl.instrs;
        int ip = 0;
        while (ip < self.impl.codeSize) {
            if (trace || this.debug) {
                this.trace(self, ip);
            }
            short opcode = code[ip];
            this.current_ip = ip++;
            switch (opcode) {
                case 1: {
                    this.load_str(self, ip);
                    ip += 2;
                    break;
                }
                case 2: {
                    Object o;
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    try {
                        o = this.getAttribute(self, name);
                        if (o == ST.EMPTY_ATTR) {
                            o = null;
                        }
                    }
                    catch (STNoSuchAttributeException nsae) {
                        this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.NO_SUCH_ATTRIBUTE, name);
                        o = null;
                    }
                    this.operands[++this.sp] = o;
                    break;
                }
                case 3: {
                    int valueIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = self.locals[valueIndex];
                    if (o == ST.EMPTY_ATTR) {
                        o = null;
                    }
                    this.operands[++this.sp] = o;
                    break;
                }
                case 4: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = this.operands[this.sp--];
                    String name = self.impl.strings[nameIndex];
                    this.operands[++this.sp] = this.getObjectProperty(out, self, o, name);
                    break;
                }
                case 5: {
                    Object propName = this.operands[this.sp--];
                    Object o = this.operands[this.sp];
                    this.operands[this.sp] = this.getObjectProperty(out, self, o, propName);
                    break;
                }
                case 8: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    int nargs = Interpreter.getShort(code, ip += 2);
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, self, ip += 2, name);
                    this.storeArgs(self, nargs, st);
                    this.sp -= nargs;
                    this.operands[++this.sp] = st;
                    break;
                }
                case 9: {
                    int nargs = Interpreter.getShort(code, ip);
                    String name = (String)this.operands[this.sp - nargs];
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, self, ip += 2, name);
                    this.storeArgs(self, nargs, st);
                    this.sp -= nargs;
                    --this.sp;
                    this.operands[++this.sp] = st;
                    break;
                }
                case 10: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    Map attrs = (Map)this.operands[this.sp--];
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, self, ip += 2, name);
                    this.storeArgs(self, attrs, st);
                    this.operands[++this.sp] = st;
                    break;
                }
                case 11: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    int nargs = Interpreter.getShort(code, ip += 2);
                    ip += 2;
                    this.super_new(self, name, nargs);
                    break;
                }
                case 12: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    Map attrs = (Map)this.operands[this.sp--];
                    this.super_new(self, name, attrs);
                    break;
                }
                case 6: {
                    int optionIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = this.operands[this.sp--];
                    Object[] options = (Object[])this.operands[this.sp];
                    options[optionIndex] = o;
                    break;
                }
                case 7: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    ip += 2;
                    Object o = this.operands[this.sp--];
                    Map attrs = (Map)this.operands[this.sp];
                    attrs.put(name, o);
                    break;
                }
                case 13: {
                    Object o = this.operands[this.sp--];
                    int n1 = this.writeObjectNoOptions(out, self, o);
                    n += n1;
                    this.nwline += n1;
                    break;
                }
                case 14: {
                    Object[] options = (Object[])this.operands[this.sp--];
                    Object o = this.operands[this.sp--];
                    int n2 = this.writeObjectWithOptions(out, self, o, options);
                    n += n2;
                    this.nwline += n2;
                    break;
                }
                case 15: {
                    ST st = (ST)this.operands[this.sp--];
                    Object o = this.operands[this.sp--];
                    this.map(self, o, st);
                    break;
                }
                case 16: {
                    Object o;
                    int nmaps = Interpreter.getShort(code, ip);
                    ip += 2;
                    ArrayList<ST> templates = new ArrayList<ST>();
                    for (int i = nmaps - 1; i >= 0; --i) {
                        templates.add((ST)this.operands[this.sp - i]);
                    }
                    this.sp -= nmaps;
                    if ((o = this.operands[this.sp--]) == null) break;
                    this.rot_map(self, o, templates);
                    break;
                }
                case 17: {
                    ST st = (ST)this.operands[this.sp--];
                    int nmaps = Interpreter.getShort(code, ip);
                    ip += 2;
                    ArrayList<Object> exprs = new ArrayList<Object>();
                    for (int i = nmaps - 1; i >= 0; --i) {
                        exprs.add(this.operands[this.sp - i]);
                    }
                    this.sp -= nmaps;
                    this.operands[++this.sp] = this.zip_map(self, exprs, st);
                    break;
                }
                case 18: {
                    ip = Interpreter.getShort(code, ip);
                    break;
                }
                case 19: {
                    int addr = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = this.operands[this.sp--];
                    if (this.testAttributeTrue(o)) break;
                    ip = addr;
                    break;
                }
                case 20: {
                    this.operands[++this.sp] = new Object[Compiler.NUM_OPTIONS];
                    break;
                }
                case 21: {
                    this.operands[++this.sp] = new HashMap();
                    break;
                }
                case 22: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    Map attrs = (Map)this.operands[this.sp];
                    this.passthru(self, name, attrs);
                    break;
                }
                case 24: {
                    this.operands[++this.sp] = new ArrayList();
                    break;
                }
                case 25: {
                    Object o = this.operands[this.sp--];
                    List list = (List)this.operands[this.sp];
                    this.addToList(list, o);
                    break;
                }
                case 26: {
                    this.operands[this.sp] = this.toString(out, self, this.operands[this.sp]);
                    break;
                }
                case 27: {
                    this.operands[this.sp] = this.first(this.operands[this.sp]);
                    break;
                }
                case 28: {
                    this.operands[this.sp] = this.last(this.operands[this.sp]);
                    break;
                }
                case 29: {
                    this.operands[this.sp] = this.rest(this.operands[this.sp]);
                    break;
                }
                case 30: {
                    this.operands[this.sp] = this.trunc(this.operands[this.sp]);
                    break;
                }
                case 31: {
                    this.operands[this.sp] = this.strip(this.operands[this.sp]);
                    break;
                }
                case 32: {
                    Object o = this.operands[this.sp--];
                    if (o.getClass() == String.class) {
                        this.operands[++this.sp] = ((String)o).trim();
                        break;
                    }
                    this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.EXPECTING_STRING, "trim", (Object)o.getClass().getName());
                    this.operands[++this.sp] = o;
                    break;
                }
                case 33: {
                    this.operands[this.sp] = this.length(this.operands[this.sp]);
                    break;
                }
                case 34: {
                    Object o = this.operands[this.sp--];
                    if (o.getClass() == String.class) {
                        this.operands[++this.sp] = ((String)o).length();
                        break;
                    }
                    this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.EXPECTING_STRING, "strlen", (Object)o.getClass().getName());
                    this.operands[++this.sp] = 0;
                    break;
                }
                case 35: {
                    this.operands[this.sp] = this.reverse(this.operands[this.sp]);
                    break;
                }
                case 36: {
                    this.operands[this.sp] = !this.testAttributeTrue(this.operands[this.sp]);
                    break;
                }
                case 37: {
                    Object right = this.operands[this.sp--];
                    Object left = this.operands[this.sp--];
                    this.operands[++this.sp] = this.testAttributeTrue(left) || this.testAttributeTrue(right);
                    break;
                }
                case 38: {
                    Object right = this.operands[this.sp--];
                    Object left = this.operands[this.sp--];
                    this.operands[++this.sp] = this.testAttributeTrue(left) && this.testAttributeTrue(right);
                    break;
                }
                case 39: {
                    int strIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    this.indent(out, self, strIndex);
                    break;
                }
                case 40: {
                    out.popIndentation();
                    break;
                }
                case 41: {
                    try {
                        if (prevOpcode == 41 || prevOpcode == 39 || this.nwline > 0) {
                            out.write(Misc.newline);
                        }
                        this.nwline = 0;
                    }
                    catch (IOException ioe) {
                        this.errMgr.IOError(self, ErrorType.WRITE_IO_ERROR, ioe);
                    }
                    break;
                }
                case 42: {
                    break;
                }
                case 43: {
                    --this.sp;
                    break;
                }
                case 44: {
                    this.operands[++this.sp] = null;
                    break;
                }
                case 45: {
                    this.operands[++this.sp] = true;
                    break;
                }
                case 46: {
                    this.operands[++this.sp] = false;
                    break;
                }
                case 47: {
                    int strIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = self.impl.strings[strIndex];
                    int n1 = this.writeObjectNoOptions(out, self, o);
                    n += n1;
                    this.nwline += n1;
                    break;
                }
                default: {
                    this.errMgr.internalError(self, "invalid bytecode @ " + (ip - 1) + ": " + opcode, null);
                    self.impl.dump();
                }
            }
            prevOpcode = opcode;
        }
        if (this.debug) {
            int stop = out.index() - 1;
            EvalTemplateEvent e = new EvalTemplateEvent(this.currentScope, start, stop);
            this.trackDebugEvent(self, e);
        }
        return n;
    }

    void load_str(ST self, int ip) {
        int strIndex = Interpreter.getShort(self.impl.instrs, ip);
        ip += 2;
        this.operands[++this.sp] = self.impl.strings[strIndex];
    }

    void super_new(ST self, String name, int nargs) {
        ST st = null;
        CompiledST imported = self.impl.nativeGroup.lookupImportedTemplate(name);
        if (imported == null) {
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.NO_IMPORTED_TEMPLATE, name);
            st = self.groupThatCreatedThisInstance.createStringTemplateInternally(new CompiledST());
        } else {
            st = imported.nativeGroup.getEmbeddedInstanceOf(this, self, this.current_ip, name);
            st.groupThatCreatedThisInstance = this.group;
        }
        this.storeArgs(self, nargs, st);
        this.sp -= nargs;
        this.operands[++this.sp] = st;
    }

    void super_new(ST self, String name, Map<String, Object> attrs) {
        ST st = null;
        CompiledST imported = self.impl.nativeGroup.lookupImportedTemplate(name);
        if (imported == null) {
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.NO_IMPORTED_TEMPLATE, name);
            st = self.groupThatCreatedThisInstance.createStringTemplateInternally(new CompiledST());
        } else {
            st = imported.nativeGroup.createStringTemplateInternally(imported);
            st.groupThatCreatedThisInstance = this.group;
        }
        this.storeArgs(self, attrs, st);
        this.operands[++this.sp] = st;
    }

    void passthru(ST self, String templateName, Map<String, Object> attrs) {
        CompiledST c = this.group.lookupTemplate(templateName);
        if (c == null) {
            return;
        }
        if (c.formalArguments == null) {
            return;
        }
        for (FormalArgument arg : c.formalArguments.values()) {
            if (attrs.containsKey(arg.name)) continue;
            try {
                Object o = this.getAttribute(self, arg.name);
                if (o == ST.EMPTY_ATTR && arg.defaultValueToken == null) {
                    attrs.put(arg.name, null);
                    continue;
                }
                if (o == ST.EMPTY_ATTR) continue;
                attrs.put(arg.name, o);
            }
            catch (STNoSuchAttributeException nsae) {
                if (arg.defaultValueToken != null) continue;
                attrs.put(arg.name, null);
            }
        }
    }

    void storeArgs(ST self, Map<String, Object> attrs, ST st) {
        int nformalArgs = 0;
        if (st.impl.formalArguments != null) {
            nformalArgs = st.impl.formalArguments.size();
        }
        int nargs = 0;
        if (attrs != null) {
            nargs = attrs.size();
        }
        if (nargs < nformalArgs - st.impl.numberOfArgsWithDefaultValues || nargs > nformalArgs) {
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.ARGUMENT_COUNT_MISMATCH, nargs, st.impl.name, nformalArgs);
        }
        for (String argName : attrs.keySet()) {
            if (st.impl.formalArguments == null || !st.impl.formalArguments.containsKey(argName)) {
                this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.NO_SUCH_ATTRIBUTE, argName);
                continue;
            }
            Object o = attrs.get(argName);
            st.rawSetAttribute(argName, o);
        }
    }

    void storeArgs(ST self, int nargs, ST st) {
        int nformalArgs = 0;
        if (st.impl.formalArguments != null) {
            nformalArgs = st.impl.formalArguments.size();
        }
        int firstArg = this.sp - (nargs - 1);
        int numToStore = Math.min(nargs, nformalArgs);
        if (st.impl.isAnonSubtemplate) {
            nformalArgs -= predefinedAnonSubtemplateAttributes.size();
        }
        if (nargs < nformalArgs - st.impl.numberOfArgsWithDefaultValues || nargs > nformalArgs) {
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.ARGUMENT_COUNT_MISMATCH, nargs, st.impl.name, nformalArgs);
        }
        if (st.impl.formalArguments == null) {
            return;
        }
        Iterator<String> argNames = st.impl.formalArguments.keySet().iterator();
        for (int i = 0; i < numToStore; ++i) {
            Object o = this.operands[firstArg + i];
            String argName = argNames.next();
            st.rawSetAttribute(argName, o);
        }
    }

    protected void indent(STWriter out, ST self, int strIndex) {
        String indent = self.impl.strings[strIndex];
        if (this.debug) {
            int start = out.index();
            IndentEvent e = new IndentEvent(this.currentScope, start, start + indent.length() - 1, this.getExprStartChar(self), this.getExprStopChar(self));
            this.trackDebugEvent(self, e);
        }
        out.pushIndentation(indent);
    }

    protected int writeObjectNoOptions(STWriter out, ST self, Object o) {
        int start = out.index();
        int n = this.writeObject(out, self, o, null);
        if (this.debug) {
            EvalExprEvent e = new EvalExprEvent(this.currentScope, start, out.index() - 1, this.getExprStartChar(self), this.getExprStopChar(self));
            this.trackDebugEvent(self, e);
        }
        return n;
    }

    protected int writeObjectWithOptions(STWriter out, ST self, Object o, Object[] options) {
        int start = out.index();
        String[] optionStrings = null;
        if (options != null) {
            optionStrings = new String[options.length];
            for (int i = 0; i < Compiler.NUM_OPTIONS; ++i) {
                optionStrings[i] = this.toString(out, self, options[i]);
            }
        }
        if (options != null && options[Option.ANCHOR.ordinal()] != null) {
            out.pushAnchorPoint();
        }
        int n = this.writeObject(out, self, o, optionStrings);
        if (options != null && options[Option.ANCHOR.ordinal()] != null) {
            out.popAnchorPoint();
        }
        if (this.debug) {
            EvalExprEvent e = new EvalExprEvent(this.currentScope, start, out.index() - 1, this.getExprStartChar(self), this.getExprStopChar(self));
            this.trackDebugEvent(self, e);
        }
        return n;
    }

    protected int writeObject(STWriter out, ST self, Object o, String[] options) {
        int n = 0;
        if (o == null) {
            if (options != null && options[Option.NULL.ordinal()] != null) {
                o = options[Option.NULL.ordinal()];
            } else {
                return 0;
            }
        }
        if (o instanceof ST) {
            ST st = (ST)o;
            if (options != null && options[Option.WRAP.ordinal()] != null) {
                try {
                    out.writeWrap(options[Option.WRAP.ordinal()]);
                }
                catch (IOException ioe) {
                    this.errMgr.IOError(self, ErrorType.WRITE_IO_ERROR, ioe);
                }
            }
            n = this.exec(out, st);
        } else {
            o = this.convertAnythingIteratableToIterator(o);
            try {
                n = o instanceof Iterator ? this.writeIterator(out, self, o, options) : this.writePOJO(out, o, options);
            }
            catch (IOException ioe) {
                this.errMgr.IOError(self, ErrorType.WRITE_IO_ERROR, ioe, o);
            }
        }
        return n;
    }

    protected int writeIterator(STWriter out, ST self, Object o, String[] options) throws IOException {
        if (o == null) {
            return 0;
        }
        int n = 0;
        Iterator it = (Iterator)o;
        String separator = null;
        if (options != null) {
            separator = options[Option.SEPARATOR.ordinal()];
        }
        boolean seenAValue = false;
        while (it.hasNext()) {
            int nw;
            boolean needSeparator;
            Object iterValue = it.next();
            boolean bl = needSeparator = seenAValue && separator != null && (iterValue != null || options[Option.NULL.ordinal()] != null);
            if (needSeparator) {
                n += out.writeSeparator(separator);
            }
            if ((nw = this.writeObject(out, self, iterValue, options)) > 0) {
                seenAValue = true;
            }
            n += nw;
        }
        return n;
    }

    protected int writePOJO(STWriter out, Object o, String[] options) throws IOException {
        AttributeRenderer r;
        String formatString = null;
        if (options != null) {
            formatString = options[Option.FORMAT.ordinal()];
        }
        String v = (r = this.currentScope.st.impl.nativeGroup.getAttributeRenderer(o.getClass())) != null ? r.toString(o, formatString, this.locale) : o.toString();
        int n = options != null && options[Option.WRAP.ordinal()] != null ? out.write(v, options[Option.WRAP.ordinal()]) : out.write(v);
        return n;
    }

    protected int getExprStartChar(ST self) {
        Interval templateLocation = self.impl.sourceMap[this.current_ip];
        if (templateLocation != null) {
            return templateLocation.a;
        }
        return -1;
    }

    protected int getExprStopChar(ST self) {
        Interval templateLocation = self.impl.sourceMap[this.current_ip];
        if (templateLocation != null) {
            return templateLocation.b;
        }
        return -1;
    }

    protected void map(ST self, Object attr, final ST st) {
        this.rot_map(self, attr, (List<ST>)new ArrayList<ST>(){
            {
                this.add(st);
            }
        });
    }

    protected void rot_map(ST self, Object attr, List<ST> prototypes) {
        if (attr == null) {
            this.operands[++this.sp] = null;
            return;
        }
        if ((attr = this.convertAnythingIteratableToIterator(attr)) instanceof Iterator) {
            List<ST> mapped = this.rot_map_iterator(self, (Iterator)attr, prototypes);
            this.operands[++this.sp] = mapped;
        } else {
            ST proto = prototypes.get(0);
            ST st = this.group.createStringTemplateInternally(proto);
            if (st != null) {
                this.setFirstArgument(self, st, attr);
                if (st.impl.isAnonSubtemplate) {
                    st.rawSetAttribute("i0", 0);
                    st.rawSetAttribute("i", 1);
                }
                this.operands[++this.sp] = st;
            } else {
                this.operands[++this.sp] = null;
            }
        }
    }

    protected List<ST> rot_map_iterator(ST self, Iterator attr, List<ST> prototypes) {
        ArrayList<ST> mapped = new ArrayList<ST>();
        Iterator iter = attr;
        int i0 = 0;
        int i = 1;
        int ti = 0;
        while (iter.hasNext()) {
            Object iterValue = iter.next();
            if (iterValue == null) {
                mapped.add(null);
                continue;
            }
            int templateIndex = ti % prototypes.size();
            ++ti;
            ST proto = prototypes.get(templateIndex);
            ST st = this.group.createStringTemplateInternally(proto);
            this.setFirstArgument(self, st, iterValue);
            if (st.impl.isAnonSubtemplate) {
                st.rawSetAttribute("i0", i0);
                st.rawSetAttribute("i", i);
            }
            mapped.add(st);
            ++i0;
            ++i;
        }
        return mapped;
    }

    protected ST.AttributeList zip_map(ST self, List<Object> exprs, ST prototype) {
        if (exprs == null || prototype == null || exprs.size() == 0) {
            return null;
        }
        for (int i = 0; i < exprs.size(); ++i) {
            Object attr = exprs.get(i);
            if (attr == null) continue;
            exprs.set(i, this.convertAnythingToIterator(attr));
        }
        int numExprs = exprs.size();
        CompiledST code = prototype.impl;
        Map<String, FormalArgument> formalArguments = code.formalArguments;
        if (!code.hasFormalArgs || formalArguments == null) {
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.MISSING_FORMAL_ARGUMENTS);
            return null;
        }
        Object[] formalArgumentNames = formalArguments.keySet().toArray();
        int nformalArgs = formalArgumentNames.length;
        if (prototype.isAnonSubtemplate()) {
            nformalArgs -= predefinedAnonSubtemplateAttributes.size();
        }
        if (nformalArgs != numExprs) {
            int shorterSize;
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.MAP_ARGUMENT_COUNT_MISMATCH, numExprs, (Object)nformalArgs);
            numExprs = shorterSize = Math.min(formalArgumentNames.length, numExprs);
            Object[] newFormalArgumentNames = new Object[shorterSize];
            System.arraycopy(formalArgumentNames, 0, newFormalArgumentNames, 0, shorterSize);
            formalArgumentNames = newFormalArgumentNames;
        }
        ST.AttributeList results = new ST.AttributeList();
        int i = 0;
        while (true) {
            int numEmpty = 0;
            ST embedded = this.group.createStringTemplateInternally(prototype);
            embedded.rawSetAttribute("i0", i);
            embedded.rawSetAttribute("i", i + 1);
            for (int a = 0; a < numExprs; ++a) {
                Iterator it = (Iterator)exprs.get(a);
                if (it != null && it.hasNext()) {
                    String argName = (String)formalArgumentNames[a];
                    Object iteratedValue = it.next();
                    embedded.rawSetAttribute(argName, iteratedValue);
                    continue;
                }
                ++numEmpty;
            }
            if (numEmpty == numExprs) break;
            results.add(embedded);
            ++i;
        }
        return results;
    }

    protected void setFirstArgument(ST self, ST st, Object attr) {
        if (st.impl.formalArguments == null) {
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.ARGUMENT_COUNT_MISMATCH, 1, st.impl.name, 0);
            return;
        }
        st.locals[0] = attr;
    }

    protected void addToList(List<Object> list, Object o) {
        if ((o = this.convertAnythingIteratableToIterator(o)) instanceof Iterator) {
            Iterator it = (Iterator)o;
            while (it.hasNext()) {
                list.add(it.next());
            }
        } else {
            list.add(o);
        }
    }

    public Object first(Object v) {
        Iterator it;
        if (v == null) {
            return null;
        }
        Object r = v;
        if ((v = this.convertAnythingIteratableToIterator(v)) instanceof Iterator && (it = (Iterator)v).hasNext()) {
            r = it.next();
        }
        return r;
    }

    public Object last(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof List) {
            return ((List)v).get(((List)v).size() - 1);
        }
        if (v.getClass().isArray()) {
            Object[] elems = (Object[])v;
            return elems[elems.length - 1];
        }
        Object last = v;
        if ((v = this.convertAnythingIteratableToIterator(v)) instanceof Iterator) {
            Iterator it = (Iterator)v;
            while (it.hasNext()) {
                last = it.next();
            }
        }
        return last;
    }

    public Object rest(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof List) {
            List elems = (List)v;
            if (elems.size() <= 1) {
                return null;
            }
            return elems.subList(1, elems.size());
        }
        if ((v = this.convertAnythingIteratableToIterator(v)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)v;
            if (!it.hasNext()) {
                return null;
            }
            it.next();
            while (it.hasNext()) {
                Object o = it.next();
                a.add(o);
            }
            return a;
        }
        return null;
    }

    public Object trunc(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof List) {
            List elems = (List)v;
            if (elems.size() <= 1) {
                return null;
            }
            return elems.subList(0, elems.size() - 1);
        }
        if ((v = this.convertAnythingIteratableToIterator(v)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)v;
            while (it.hasNext()) {
                Object o = it.next();
                if (!it.hasNext()) continue;
                a.add(o);
            }
            return a;
        }
        return null;
    }

    public Object strip(Object v) {
        if (v == null) {
            return null;
        }
        if ((v = this.convertAnythingIteratableToIterator(v)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)v;
            while (it.hasNext()) {
                Object o = it.next();
                if (o == null) continue;
                a.add(o);
            }
            return a;
        }
        return v;
    }

    public Object reverse(Object v) {
        if (v == null) {
            return null;
        }
        if ((v = this.convertAnythingIteratableToIterator(v)) instanceof Iterator) {
            LinkedList a = new LinkedList();
            Iterator it = (Iterator)v;
            while (it.hasNext()) {
                a.add(0, it.next());
            }
            return a;
        }
        return v;
    }

    public Object length(Object v) {
        if (v == null) {
            return 0;
        }
        int i = 1;
        if (v instanceof Map) {
            i = ((Map)v).size();
        } else if (v instanceof Collection) {
            i = ((Collection)v).size();
        } else if (v instanceof Object[]) {
            i = ((Object[])v).length;
        } else if (v instanceof int[]) {
            i = ((int[])v).length;
        } else if (v instanceof long[]) {
            i = ((long[])v).length;
        } else if (v instanceof float[]) {
            i = ((float[])v).length;
        } else if (v instanceof double[]) {
            i = ((double[])v).length;
        } else if (v instanceof Iterator) {
            Iterator it = (Iterator)v;
            i = 0;
            while (it.hasNext()) {
                it.next();
                ++i;
            }
        }
        return i;
    }

    protected String toString(STWriter out, ST self, Object value) {
        if (value != null) {
            if (value.getClass() == String.class) {
                return (String)value;
            }
            StringWriter sw = new StringWriter();
            STWriter stw = null;
            try {
                Class<?> writerClass = out.getClass();
                Constructor<?> ctor = writerClass.getConstructor(Writer.class);
                stw = (STWriter)ctor.newInstance(sw);
            }
            catch (Exception e) {
                stw = new AutoIndentWriter(sw);
                this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.WRITER_CTOR_ISSUE, out.getClass().getSimpleName());
            }
            this.writeObjectNoOptions(stw, self, value);
            return sw.toString();
        }
        return null;
    }

    public Object convertAnythingIteratableToIterator(Object o) {
        Iterator iter = null;
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            iter = ((Collection)o).iterator();
        } else if (o.getClass().isArray()) {
            iter = new ArrayIterator(o);
        } else if (this.currentScope.st.groupThatCreatedThisInstance.iterateAcrossValues && o instanceof Map) {
            iter = ((Map)o).values().iterator();
        } else if (o instanceof Map) {
            iter = ((Map)o).keySet().iterator();
        } else if (o instanceof Iterator) {
            iter = (Iterator)o;
        }
        if (iter == null) {
            return o;
        }
        return iter;
    }

    public Iterator convertAnythingToIterator(Object o) {
        if ((o = this.convertAnythingIteratableToIterator(o)) instanceof Iterator) {
            return (Iterator)o;
        }
        ST.AttributeList singleton = new ST.AttributeList(1);
        singleton.add(o);
        return singleton.iterator();
    }

    protected boolean testAttributeTrue(Object a) {
        if (a == null) {
            return false;
        }
        if (a instanceof Boolean) {
            return (Boolean)a;
        }
        if (a instanceof Collection) {
            return ((Collection)a).size() > 0;
        }
        if (a instanceof Map) {
            return ((Map)a).size() > 0;
        }
        if (a instanceof Iterator) {
            return ((Iterator)a).hasNext();
        }
        return true;
    }

    protected Object getObjectProperty(STWriter out, ST self, Object o, Object property) {
        if (o == null) {
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.NO_SUCH_PROPERTY, "null attribute");
            return null;
        }
        try {
            ModelAdaptor adap = self.groupThatCreatedThisInstance.getModelAdaptor(o.getClass());
            return adap.getProperty(this, self, o, property, this.toString(out, self, property));
        }
        catch (STNoSuchPropertyException e) {
            this.errMgr.runTimeError(this, self, this.current_ip, ErrorType.NO_SUCH_PROPERTY, e, (Object)(o.getClass().getName() + "." + property));
            return null;
        }
    }

    public Object getAttribute(ST self, String name) {
        InstanceScope scope = this.currentScope;
        while (scope != null) {
            ST p = scope.st;
            FormalArgument localArg = null;
            if (p.impl.formalArguments != null) {
                localArg = p.impl.formalArguments.get(name);
            }
            if (localArg != null) {
                Object o = p.locals[localArg.index];
                return o;
            }
            scope = scope.parent;
        }
        STGroup g = self.impl.nativeGroup;
        Object o = this.getDictionary(g, name);
        if (o != null) {
            return o;
        }
        if (ST.cachedNoSuchAttrException == null) {
            ST.cachedNoSuchAttrException = new STNoSuchAttributeException();
        }
        ST.cachedNoSuchAttrException.name = name;
        ST.cachedNoSuchAttrException.scope = this.currentScope;
        throw ST.cachedNoSuchAttrException;
    }

    public Object getDictionary(STGroup g, String name) {
        if (g.isDictionary(name)) {
            return g.rawGetDictionary(name);
        }
        if (g.imports != null) {
            for (STGroup sup : g.imports) {
                Object o = this.getDictionary(sup, name);
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    public void setDefaultArguments(STWriter out, ST invokedST) {
        if (invokedST.impl.formalArguments == null || invokedST.impl.numberOfArgsWithDefaultValues == 0) {
            return;
        }
        for (FormalArgument arg : invokedST.impl.formalArguments.values()) {
            if (invokedST.locals[arg.index] != ST.EMPTY_ATTR || arg.defaultValueToken == null) continue;
            if (arg.defaultValueToken.getType() == 10) {
                CompiledST code = arg.compiledDefaultValue;
                if (code == null) {
                    code = new CompiledST();
                }
                ST defaultArgST = this.group.createStringTemplateInternally(code);
                defaultArgST.groupThatCreatedThisInstance = this.group;
                String defArgTemplate = arg.defaultValueToken.getText();
                if (defArgTemplate.startsWith("{" + this.group.delimiterStartChar + "(") && defArgTemplate.endsWith(")" + this.group.delimiterStopChar + "}")) {
                    invokedST.rawSetAttribute(arg.name, this.toString(out, invokedST, defaultArgST));
                    continue;
                }
                invokedST.rawSetAttribute(arg.name, defaultArgST);
                continue;
            }
            invokedST.rawSetAttribute(arg.name, arg.defaultValue);
        }
    }

    private void popScope() {
        this.current_ip = this.currentScope.ret_ip;
        this.currentScope = this.currentScope.parent;
    }

    private void pushScope(ST self) {
        this.currentScope = new InstanceScope(this.currentScope, self);
        if (this.debug) {
            this.currentScope.events = new ArrayList<InterpEvent>();
            this.currentScope.childEvalTemplateEvents = new ArrayList<EvalTemplateEvent>();
        }
        this.currentScope.ret_ip = this.current_ip;
    }

    public static String getEnclosingInstanceStackString(InstanceScope scope) {
        List<ST> templates = Interpreter.getEnclosingInstanceStack(scope, true);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (ST st : templates) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(st.getName());
            ++i;
        }
        return buf.toString();
    }

    public static List<ST> getEnclosingInstanceStack(InstanceScope scope, boolean topdown) {
        LinkedList<ST> stack = new LinkedList<ST>();
        InstanceScope p = scope;
        while (p != null) {
            if (topdown) {
                stack.add(0, p.st);
            } else {
                stack.add(p.st);
            }
            p = p.parent;
        }
        return stack;
    }

    public static List<InstanceScope> getScopeStack(InstanceScope scope, boolean topdown) {
        LinkedList<InstanceScope> stack = new LinkedList<InstanceScope>();
        InstanceScope p = scope;
        while (p != null) {
            if (topdown) {
                stack.add(0, p);
            } else {
                stack.add(p);
            }
            p = p.parent;
        }
        return stack;
    }

    public static List<EvalTemplateEvent> getEvalTemplateEventStack(InstanceScope scope, boolean topdown) {
        LinkedList<EvalTemplateEvent> stack = new LinkedList<EvalTemplateEvent>();
        InstanceScope p = scope;
        while (p != null) {
            EvalTemplateEvent eval = (EvalTemplateEvent)p.events.get(p.events.size() - 1);
            if (topdown) {
                stack.add(0, eval);
            } else {
                stack.add(eval);
            }
            p = p.parent;
        }
        return stack;
    }

    protected void trace(ST self, int ip) {
        StringBuilder tr = new StringBuilder();
        BytecodeDisassembler dis = new BytecodeDisassembler(self.impl);
        StringBuilder buf = new StringBuilder();
        dis.disassembleInstruction(buf, ip);
        String name = self.impl.name + ":";
        if (self.impl.name == "anonymous") {
            name = "";
        }
        tr.append(String.format("%-40s", name + buf));
        tr.append("\tstack=[");
        for (int i = 0; i <= this.sp; ++i) {
            Object o = this.operands[i];
            this.printForTrace(tr, o);
        }
        tr.append(" ], calls=");
        tr.append(Interpreter.getEnclosingInstanceStackString(this.currentScope));
        tr.append(", sp=" + this.sp + ", nw=" + this.nwline);
        String s = tr.toString();
        if (this.debug) {
            this.executeTrace.add(s);
        }
        if (trace) {
            System.out.println(s);
        }
    }

    protected void printForTrace(StringBuilder tr, Object o) {
        if (o instanceof ST) {
            if (((ST)o).impl == null) {
                tr.append("bad-template()");
            } else {
                tr.append(" " + ((ST)o).impl.name + "()");
            }
            return;
        }
        if ((o = this.convertAnythingIteratableToIterator(o)) instanceof Iterator) {
            Iterator it = (Iterator)o;
            tr.append(" [");
            while (it.hasNext()) {
                Object iterValue = it.next();
                this.printForTrace(tr, iterValue);
            }
            tr.append(" ]");
        } else {
            tr.append(" " + o);
        }
    }

    public List<InterpEvent> getEvents() {
        return this.events;
    }

    protected void trackDebugEvent(ST self, InterpEvent e) {
        InstanceScope parent;
        this.events.add(e);
        this.currentScope.events.add(e);
        if (e instanceof EvalTemplateEvent && (parent = this.currentScope.parent) != null) {
            this.currentScope.parent.childEvalTemplateEvents.add((EvalTemplateEvent)e);
        }
    }

    public List<String> getExecutionTrace() {
        return this.executeTrace;
    }

    public static int getShort(byte[] memory, int index) {
        int b1 = memory[index] & 0xFF;
        int b2 = memory[index + 1] & 0xFF;
        return b1 << 8 | b2;
    }

    public static enum Option {
        ANCHOR,
        FORMAT,
        NULL,
        SEPARATOR,
        WRAP;

    }
}

