/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.tinylog;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import org.pmw.tinylog.LogEntryForwarder;
import org.pmw.tinylog.Logger;

public class TinyLog
extends AbstractLog {
    private static final long serialVersionUID = -4848042277045993735L;
    private static final int DEPTH = 2;
    private int level;
    private String name;

    public TinyLog(Class<?> clazz) {
        this.name = clazz.getName();
        this.level = Logger.getLevel((String)this.name).ordinal();
    }

    public TinyLog(String name) {
        this.name = name;
        this.level = Logger.getLevel((String)name).ordinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= org.pmw.tinylog.Level.TRACE.ordinal();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log(Level.TRACE, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.log(Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= org.pmw.tinylog.Level.DEBUG.ordinal();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log(Level.DEBUG, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.log(Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level <= org.pmw.tinylog.Level.INFO.ordinal();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log(Level.INFO, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.log(Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= org.pmw.tinylog.Level.WARNING.ordinal();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log(Level.WARN, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.log(Level.WARN, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= org.pmw.tinylog.Level.ERROR.ordinal();
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.log(Level.ERROR, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.log(Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        LogEntryForwarder.forward((int)2, (org.pmw.tinylog.Level)this.toTinyLevel(level), (Throwable)TinyLog.getLastArgumentIfThrowable(new Object[]{level, arguments}), (String)format, (Object[])arguments);
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        LogEntryForwarder.forward((int)2, (org.pmw.tinylog.Level)this.toTinyLevel(level), (Throwable)t, (String)format, (Object[])arguments);
    }

    private org.pmw.tinylog.Level toTinyLevel(Level level) {
        org.pmw.tinylog.Level tinyLevel;
        switch (level) {
            case TRACE: {
                tinyLevel = org.pmw.tinylog.Level.TRACE;
                break;
            }
            case DEBUG: {
                tinyLevel = org.pmw.tinylog.Level.DEBUG;
                break;
            }
            case INFO: {
                tinyLevel = org.pmw.tinylog.Level.INFO;
                break;
            }
            case WARN: {
                tinyLevel = org.pmw.tinylog.Level.WARNING;
                break;
            }
            case ERROR: {
                tinyLevel = org.pmw.tinylog.Level.ERROR;
                break;
            }
            case OFF: {
                tinyLevel = org.pmw.tinylog.Level.OFF;
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", new Object[]{level}));
            }
        }
        return tinyLevel;
    }

    private static Throwable getLastArgumentIfThrowable(Object ... arguments) {
        if (ArrayUtil.isNotEmpty(arguments) && arguments[arguments.length - 1] instanceof Throwable) {
            return (Throwable)arguments[arguments.length - 1];
        }
        return null;
    }
}

