package cn.com.duiba.tuia.pangea.center.api.dto.spread;

import cn.com.duiba.tuia.pangea.center.api.constant.SpreadFlowTypeEnum;
import cn.com.duiba.tuia.pangea.center.api.req.BaseQueryReq;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Set;

@Data
public class SpreadActivityDTO extends BaseQueryReq{

    private Long id;

    /**
     *  媒体id
     */
    private Long appId;

    /**
     *  媒体名
     */
    private String appName;

    /**
     *  广告位id
     */
    private Long slotId;

    /**
     *  广告位名
     */
    private String slotName;

    /**
     *  老活动id
     */
    private Long oldActivityId;

    /**
     *  老活动量级
     */
    private Long oldActivityNumber;

    private String flowTypeStr;

    /**
     *  新活动id
     */
    private Long newActivityId;

    /**
     *  新活动量级
     */
    private Long newActivityNumber;

    /**
     *  铺量占比
     */
    private Integer spreadRatio;

    /**
     *  运营
     */
    private String mediaOperate;

    private String statusStr;

    private String refusedReason;

    /**
     *  流量类型  {@link SpreadFlowTypeEnum}
     */
    private Integer flowType;

    private Integer activityStatus;



    /**
     *  分组标签
     */
    private Integer groupTag;



    private Date gmtCreate;

    private Date gmtModified;

    //---------------查询条件-------------
    private Set<Long> slotIds;

    private List<Long> blacklist;

    private List<Integer> listStatus;

    //---------------校验是否存在测试计划
    private Long testPlanId;

    /**
     *  铺量计划id
     */
    private Long spreadId;

    /**
     *  是否是追加铺量：0或者null不是,1是
     */
    private Integer isAddRatio;
}
