package cn.com.duiba.tuia.pangea.center.api.req.flowmanager;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 大盘流量和流量比
 * @author yuantong
 * @version 1.0
 * @since 2019-09-06 13:15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ReqWholeOrSlotRatioDto implements Serializable {

    private static final long serialVersionUID = 91777783199865422L;

    private static final int TYPE_SLOT = 1;

    /**
     * 广告位Id
     */
    private Long slotId;

    /**
     * 分流类型 FlowTypeEnum
     */
    private Integer flowType;

    /**
     * 比例
     */
    private Integer ratio;


    /**
     * 数据显示开始时间
     */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String startTime;

    /**
     * 数据显示关闭时间
     */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String endTime;


    public boolean isExistSlotId() {
        return this.flowType == TYPE_SLOT;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}