package cn.com.duiba.tuia.pangea.center.api.req.resource;

import cn.com.duiba.tuia.pangea.center.api.dto.resource.TestResourceFlowDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 广告位活动的资源测试组列表查询
 * @author miaohongshuai
*/
@ApiModel
@Data
public class ResourceFlowTestAddOrUpdateReq implements Serializable {

    private static final long serialVersionUID = -3756785278448985640L;

    @ApiModelProperty(value = "测试计划名称", required = true, dataType = "string")
    private String planName;

    @ApiModelProperty(value = "测试计划ID")
    private Long planId;

    @ApiModelProperty(value = "测试计划开始时间", required = true)
    private String startTime;

    @ApiModelProperty(value = "测试计划结束时间", required = true)
    private String endTime;

    @ApiModelProperty(value = "流量选择类型", required = true)
    private Integer flowType;

    @ApiModelProperty(value = "测试人", required = true)
    private String testName;

    @ApiModelProperty(value = "测试人adminId")
    private Long adminId;

    @ApiModelProperty(value = "分流活动ID列表")
    private List<Long> activityIds;

    @ApiModelProperty(value = "分流广告位ID列表")
    private List<Long> slotIds;

    @ApiModelProperty(value = "默认广告位+活动 分流占比：50")
    private Integer defaultTestVisitorRatio;

    @ApiModelProperty(value = "测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层", required = true)
    private Integer testType;

    @ApiModelProperty(value = "asc ：升序，desc：降序")
    private String order;

    @ApiModelProperty(value = "用户行为缓存")
    private String userActionCache;

    @ApiModelProperty(value = "测试组配置")
    private List<TestResourceFlowDTO> testGroupList;

    @ApiModelProperty(value = "测试组配置json")
    private String testGroupListStr;

    @ApiModelProperty(value = "测试范围是否是全部有回流数据活动，1：是，0：否，使用输入的活动列表")
    private Integer testActivityAll;

    @ApiModelProperty(value = "是否是追加投放，1：是， null或0：否")
    private Integer testAddMore;

    @ApiModelProperty(value = "计划状态 0未完成 1未开始 2测试中 30到期停止 31 熔断 32运营操作下线")
    private Integer testStatus;
}
