package cn.com.duiba.tuia.pangea.center.api.dto.newactivity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 测试计划-广告位测试活动 资源（浮标）测试组
 * @author miaohongshuai
*/
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class TestActivityNewDTO implements Serializable {
    private static final long serialVersionUID = 7300663703732161238L;
    /**
     * 表映射主键
     */
    private Long testActivityNewId;
    /**
     * 测试计划id
     */
    private Long planId;
    /**
     * 测试广告位id
     */
    private Long slotId;
    /**
     * 测试组活动id
     */
    private Long activityId;
    /**
     * 分流比例，整数
     */
    private Integer flowPercent;

    /**
     * 活动测试流量
     */
    private Integer canTest;

    /**
     * 广告位当时创建计划的分流比例，整数
     */
    private Integer slotFlowPercent;

    /**
     * 实际分流比例，整数
     */
    private Integer realFlowPercent;
    /**
     * 计划开始时间
     */
    private Date startTime;
    /**
     * 计划结束时间
     */
    private Date endTime;
    /**
     * 计划状态 1未开始 2测试中 30到期停止 31 熔断 32运营操作下线
     */
    private Integer testStatus;
    /**
     * 组序号
     */
    private Integer groupTag;
    /**
     * 操作人id
     */
    private Long adminId;
    /**
     * 测试类型，0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
     */
    private Integer testType;
    /**
     * 更新状态，0：未更新，1：更新过
     */
    private Integer updateStatus;
    /**
     * 活动皮肤名称
     */
    private String skinName;

    private Date gmtCreate;
    private Date gmtModified;
}
