package cn.com.duiba.tuia.pangea.center.api.constant;

public enum SpreadFlowTypeEnum {
    BLACK_LIST(0, "黑名单"),
    NORMAL(1, "普通流量");

    private Integer type;

    private String desc;


    SpreadFlowTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getSpreadFlowType(Integer type) {
        for(SpreadFlowTypeEnum spreadFlowType : SpreadFlowTypeEnum.values()) {
            if(spreadFlowType.getType().equals(type)) {
                return spreadFlowType.getDesc();
            }
        }
        return null;
    }
}
