package cn.com.duiba.tuia.pangea.center.api.req;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author fenglijun
 * @version 1.0
 * @since 2019-09-09 10:57
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SlotUvQueryReq implements Serializable {
    private static final long serialVersionUID = 5995342798495564954L;

    private List<Long> activityIds;

    private List<Long> slotIds;

    private List<Long> appIds;

    //1 为大于 2为小于
    private Integer symbol;

    private Long planId;

    private Long uv;

    /**
     * 测试计划开始时间
     */
    private String startTime;

    /**
     * 测试计划结束时间
     */
    private String endTime;

    /**
     * 测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
     */
    private Integer testType;

    /** 测试范围是否是全部有回流数据活动，1：是，0：否，使用输入的活动列表 */
    private Integer testActivityAll;
}
