package cn.com.duiba.tuia.pangea.center.api.dto.apollo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿波罗盘古key-value
 *
 * @author wangzhanjin
 * @email
 * @date 2020-07-21 14:46:33
 */
@Data
public class ApolloKeyValueHistoryDTO implements Serializable {
    private static final long serialVersionUID = -187285892655751311L;

    private Long id;
    /**
     * key的主键id
     */
    private Long keyId;
    /**
     * 0为专项定制，其他需要列表处理json校验：1为媒体，2为广告位，3为活动，4皮肤，5广告（待定）
     */
    private Integer keyType;

    private String ownerNames;
    /**
     * 配置key名称
     */
    private String keyName;
    /**
     * 配置的描述，使用方法
     */
    private String keyDesc;
    /**
     * 配置的cf链接
     */
    private String keyCfUrl;
    /**
     * 配置key的关键字，唯一
     */
    private String keyStr;
    /**
     * 配置key对应的value值，type>0都是json
     */
    private String keyValueJson;
    private String keyIdMapStr;
    /**
     * 当前配置的开关，默认1开，0关
     */
    private Integer keyOnOff;
    /**
     * 默认1，白名单1，黑名单2
     */
    private Integer whiteBlack;
    /**
     * 当前创建人的信息
     */
    private String adminId;
    /**
     * 下线时间，待定
     */
    private Date offlineTime;
    /**
     *
     */
    private Date gmtCreate;
    /**
     * 修改时间，强删表，有历史表
     */
    private Date gmtModified;

}
