package cn.com.duiba.tuia.pangea.center.api.dto;

import cn.com.duiba.tuia.pangea.center.api.dto.resource.TestResourceFlowDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 盘古资源位测试计划投放时的计划详情数据
 * @author miaohongshuai
*/
@Data
public class PgPlanInfo implements Serializable {

    private static final long serialVersionUID = 7982429065939607749L;

    private Long planId;

    /** 广告位+活动维度测试的测试计划的活动ID */
    private Long activityId;

    /** 测试计划测试组配置 */
    private List<TestResourceFlowDTO> testResourceFlowDTOS;

    /** 广告位测试流量比例上限，针对新老活动AB测试、新活动测试 */
    private Integer slotTestLimitRatio;

    /** 资源位测试的广告位真实测试比例 */
    private Integer realFlowPercent;
    /** 资源位测试的广告位+活动的测试比例 */
    private Integer flowPercent;

    /** 测试范围是否是全部有回流数据活动，1：是，0：否，使用输入的活动列表 */
    private boolean testActivityAll;
}
