package cn.com.duiba.tuia.pangea.center.api.dto.data;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  @author: xuesong
 *  @Date: 2020/3/4 1:47 下午
 *  @Description:  计算中间类,计算过程中使用,存贮中间值
 */
@Data
@ToString
public class CalculateParamDTO implements Serializable {
    //券点击有效单广告位平均波动幅度
    private Map<Long, BigDecimal> uvSlotAveUpMap;

    //券点击单广告位每天波动幅度
    private Map<Long, List<BigDecimal>> uvSlotUpMap;

    //券点击总平均波动幅度
    private BigDecimal uvAveUp;

    //券点击上异常值
    private BigDecimal uvAbove;

    //券点击下异常值
    private BigDecimal uvDown;

    //券点击标准差
    private BigDecimal uvStd;

    //券点击有效广告位
    private List<Long> uvSlotIds;

    //券点击剔除异常后单广告位每天波动幅度
    private Map<Long, List<BigDecimal>> uvFilterSlotUpMap;

    //券点击剔除异常值后有效单广告位平均波动幅度
    private Map<Long, BigDecimal> uvFilterSlotAveUpMap;

    //券点击剔除异常值后总平均波动幅度
    private BigDecimal uvFilterAveUp;

    //券点击剔除异常值后,剩余有效广告位
    private List<Long> uvFilterSlotIds;

    //券点击剔除异常值后,稳定提升广告位
    private List<Long> uvFilterSteadySlotIds;



    //---------------每uv券点击*cvr----------------//

    //券点击*cvr有效单广告位平均波动幅度
    private Map<Long, BigDecimal> cvrUvSlotAveUpMap;

    //券点击*cvr单广告位每天波动幅度
    private Map<Long, List<BigDecimal>> cvrUvSlotUpMap;

    //券点击*cvr总平均波动幅度
    private BigDecimal cvrUvAveUp;

    //券点击*cvr上异常值
    private BigDecimal cvrUvAbove;

    //券点击*cvr下异常值
    private BigDecimal cvrUvDown;

    //券点击*cvr标准差
    private BigDecimal cvrUvStd;

    //券点击剔除异常后单广告位每天波动幅度
    private Map<Long, List<BigDecimal>> cvrUvFilterSlotUpMap;

    //券点击*cvr剔除异常值后有效单广告位平均波动幅度
    private Map<Long, BigDecimal> cvrUvFilterSlotAveUpMap;

    //券点击*cvr剔除异常值后总平均波动幅度
    private BigDecimal cvrUvFilterAveUp;

    //券点击*cvr有效广告位
    private List<Long> cvrUvSlotIds;

    //券点击*cvr剔除异常值后,剩余广告位
    private List<Long> cvrUvFilterSlotIds;

    //券点击*cvr剔除异常值后,稳定提升广告位
    private List<Long> cvrUvFilterSteadySlotIds;

    public CalculateParamDTO() {
        uvSlotAveUpMap = new HashMap<>();
        uvSlotUpMap = new HashMap<>();
        uvAveUp = BigDecimal.ZERO;
        uvAbove = BigDecimal.ZERO;
        uvDown = BigDecimal.ZERO;
        uvStd = BigDecimal.ZERO;
        uvSlotIds = new ArrayList<>();
        uvFilterSlotUpMap = new HashMap<>();
        uvFilterSlotAveUpMap = new HashMap<>();
        uvFilterAveUp = BigDecimal.ZERO;
        uvFilterSlotIds = new ArrayList<>();
        uvFilterSteadySlotIds = new ArrayList<>();



        //---------------每uv券点击*cvr----------------//

        cvrUvSlotAveUpMap = new HashMap<>();
        cvrUvSlotUpMap = new HashMap<>();
        cvrUvAveUp = BigDecimal.ZERO;
        cvrUvAbove = BigDecimal.ZERO;
        cvrUvDown = BigDecimal.ZERO;
        cvrUvStd = BigDecimal.ZERO;
        cvrUvFilterSlotUpMap = new HashMap<>();
        cvrUvFilterSlotAveUpMap = new HashMap<>();
        cvrUvFilterAveUp = BigDecimal.ZERO;
        cvrUvSlotIds = new ArrayList<>();
        cvrUvFilterSlotIds = new ArrayList<>();
        cvrUvFilterSteadySlotIds = new ArrayList<>();
    }











}
