package cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu;

/**
 * @Description: 当前代码是提供给客户端==>调用本服务端的
 * 可以Copy到本地使用！！！！！！！！！！！！！！！！！！
 * @author: 阿海
 * @create: 2020-07-28 17:28
 */
public interface ApolloPanGuService {

    /**
     * -------------------基础使用方法--------------------------------------------------------------
     * @param keyStr 关键字keyStr
     * @return 获取Apollo配置的值
     * 【重点】
     * （1）C端请按默认下线，进行开发；
     * （2）返回值是空或者空串，表示当前功能下线，默认返回""
     */
    String getIdMapStrByKeyStr(String keyStr);

    /**
     * [{ids:'8420,8417',value:'20'},{ids:'8416', value:'30'}]
     *
     * @param keyStr     关键字
     * @param resourceId 资源Id
     * @return 从Map中解析===>获取配置的值,如30
     *
     * （1）没有配置 返回null
     * （2）配置了返回具体值
     */
    String getIdMapStrByKeyStrResourceId(String keyStr, String resourceId);

    /**
     * --------------------高级使用方法---------------------------------------------------------------
     *
     * @param keyStr
     * @return 判断当前配置是否为1，一般为开关使用
     *
     * （1）没有配置 返回null
     * （2）配置了返回true/false
     */
    Boolean getIdMapStrIsOne(String keyStr);

    /**
     *
     * 当前分流支持：
     * （1）正交分流，盐值不同
     * （2）同层互斥，GroupNumber默认为1，GroupNumber=2代表可以等分3份流量A/B/C测试
     * （3）固定的坑位，广告位，活动，皮肤，广告，这样子后期就不用分流了
     *
     * @param keyStr
     * @param resourceId
     * @param deviceId
     * @param groupNumber 额外分组的数量（比如分流20%，分组数是3，将分流为3*6=18%）
     * @return; 返回值
     *
     * （1）【0】默认是返回不分流
     * （2）【0】配置了未命中分流
     * （3）【1】配置了命中分流
     * （4）【2】配置了命中分流 xxx版本
     *
     */
    int getIdMapStrDeviceIdHashFlag(String keyStr, String resourceId, String deviceId, Integer groupNumber);

}
