package cn.com.duiba.tuia.pangea.center.api.req;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * @author scd
 * @version 1.0
 * @since 2019-09-08 10:14
 */
public class ReqPageQuery implements Serializable {

    /**序列号*/
    private static final long serialVersionUID = -3434405636455884638L;

    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    /** 最大导出一万条. */
    public static final int MAX_EXPORT_SIZE = 10000;

    /** 起始记录数. */
    private Integer         rowStart        = 0;

    /** 当前页. */
    private Integer         currentPage     = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    @ApiModelProperty(value = "每页记录数", required = false)
    private Integer         pageSize = PAGE_SIZE_50;

    /** 排序字段(默认排序字段为：gmt_modified). */
    private String          sort;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String          order           = "desc";

    private Integer          orderBy;

    /** 拼接字段查询使用*/
    @ApiModelProperty(value = "拼接字段", required = false)
    private String          conditionStr;

    /** 管理员ID，数据权限使用*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private Long            managerId;

    /** 管理员能查看的app列表*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private List<Long> managerAppIds;

    /** 管理员能查看的用户列表*/
    @ApiModelProperty(value = "用户ID集合", required = false)
    private List<Long>      managerMediaIds;
    /**
     * 是否可查询
     */
    private  boolean        isQuery;

    /**
     *是否拥有超级权限
     */
    private  boolean        isSuperPermission;

    public boolean isQuery(List<Long> ids) {
        if (!this.isSuperPermission && CollectionUtils.isEmpty(ids)){
            return false;
        }
        return true;
    }

    public boolean isSuperPermission() {
        return isSuperPermission;
    }

    public void setSuperPermission(Boolean superPermission) {
        isSuperPermission = superPermission;
    }

    public String getConditionStr() {
        return conditionStr;
    }


    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }

    public Integer getRowStart() {
        return rowStart;
    }

    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Integer getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(Integer orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    public Long getManagerId() {
        return managerId;
    }


    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }


    public List<Long> getManagerAppIds() {
        return managerAppIds;
    }


    public void setManagerAppIds(List<Long> managerAppIds) {
        this.managerAppIds = managerAppIds;
    }

    public List<Long> getManagerMediaIds() {
        return managerMediaIds;
    }

    public void setManagerMediaIds(List<Long> managerMediaIds) {
        this.managerMediaIds = managerMediaIds;
    }
}
