package cn.com.duiba.tuia.pangea.center.api.req.apollo;

import cn.com.duiba.tuia.pangea.center.api.req.BaseQueryReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿波罗盘古资源列表
 *
 * @author wangzhanjin
 * @email
 * @date 2020-07-21 14:46:33
 */
@Data
public class ApolloValueListReq extends BaseQueryReq implements Serializable {
    private static final long serialVersionUID = 8324666319176232160L;

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "0为专项定制，其他需要列表处理json校验：1为媒体，2为广告位，3为活动，4皮肤，5广告（待定）")
    private Integer keyType;
    private String ownerNames;

    @ApiModelProperty(value = "配置key名称")
    private String keyName;

    @ApiModelProperty(value = "配置的描述，使用方法")
    private String keyDesc;

    @ApiModelProperty(value = "配置key关键字的id")
    private Long keyId;

    @ApiModelProperty(value = "配置key的关键字")
    private String keyStr;

    @ApiModelProperty(value = "当前配置的开关，默认1开，0关")
    private Integer keyOnOff;

    @ApiModelProperty(value = "默认1，白名单1，黑名单2")
    private Integer whiteBlack;

    @ApiModelProperty(value = "资源id，来自Apollo配置的value解析")
    private String resourceId;

    @ApiModelProperty(value = "资源id对应的配置值，一般30表示30%，具体C端使用")
    private String resouceValue;

    @ApiModelProperty(value = "资源名称，根据reouce_id和key_type，若广告位则校验广告位")
    private String resourceName;

    @ApiModelProperty(value = "当前创建，修改人的信息")
    private String adminId;

    @ApiModelProperty(value = "创建时间")
    private Date gmtCreate;

    @ApiModelProperty(value = "修改时间")
    private Date gmtModified;
}
