package cn.com.duiba.tuia.pangea.center.api.req.openweb;

import com.google.common.base.Objects;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-09-17 17:47
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PgPlanSlotRatioReq implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long slotId;
    private Long activityId;

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final PgPlanSlotRatioReq that = (PgPlanSlotRatioReq) o;
        return Objects.equal(slotId, that.slotId) &&
                Objects.equal(activityId, that.activityId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(slotId, activityId);
    }
}
