package cn.com.duiba.tuia.pangea.center.api.dto.dayu;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 场景配置
 * @author miaohongshuai
*/
@Data
public class SceneConfig implements Serializable {

    private static final long serialVersionUID = 1767916495558663707L;
    /**
     * 这个id是type=experiment 才有效的
     */
    private Long                id;

    private String              name;

    /**
     * 类型,分别为:domain\layer\experiment
     */
    private String              type;

    /**
     * 参数集合
     */
    private Map<String, String> arguments;

    /**
     * 下层配置列表
     */
    private List<SceneConfig>   configList;

    /**
     * 流量比率
     */
    private String              flowRate;

    /**
     * 流量切分类型,现在只存在两种consumerId hash 和 deviceId hash
     */
    private Integer             diversion;

}
