package cn.com.duiba.tuia.pangea.center.api.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-11-04 14:10
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class ReqResourceExportStatistics extends BaseQueryReq {

    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    /** 最大导出一万条. */
    public static final int MAX_EXPORT_SIZE = 10000;

    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String startTime;

    /** The end date. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String endTime;


    private String appName;

    private Long slotId;

    private String slotName;

    //导出类型 0为每日 1为所有
    private Integer exportType;

    //1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
    private Integer testType;

    /**
     * 测试计划id
     */
    private Long planId;

    private List<Long> slotIds;

    private List<Long> activityIds;

    private String creator;
}
