/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqProbDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2017年3月30日下午2:29:33<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.pangea.center.api.req.resource;

import cn.com.duiba.tuia.pangea.center.api.rsp.resource.RspAdvertDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 *
 * @author miaohongshuai
*/
@ApiModel
@Data
public class ProbReq implements Serializable {

    private static final long serialVersionUID = -6679396186528452788L;

    @ApiModelProperty(value = "流量入口类型，1：浮标，2：返回拦截,4:福利按钮", required = true)
    @NotNull(message = "流量入口类型不能为空")
    @Range(min=1,max=13)
    private Integer           type;

    @ApiModelProperty(value = "活动中心概率", required = true)
    @Range(min=0,max=100)
    private Integer           actCenter;

    @ApiModelProperty(value = "活动中心浮标", required = true)
    private Long           actCenterBuoyId;

    @ApiModelProperty(value = "主会场概率", required = true)
    @Range(min=0,max=100)
    private Integer           mainMeet;

    @ApiModelProperty(value = "活动概率")
    private Integer           activity;

    @ApiModelProperty(value = "直达页概率", required = true)
    @NotNull(message = "活动概率不能为空")
    @Range(min=0,max=100)
    private Integer           directPage;

    @ApiModelProperty(value = "落地页url概率", required = true)
    @NotNull(message = "落地页url概率不能为空")
    @Range(min=0,max=100)
    private Integer           url;

    @ApiModelProperty(value = "主会场推广计划ID和对应概率")
    private List<RateDto> mainMeetList;

    @ApiModelProperty(value = "活动推广计划ID和对应概率")
    private List<RateDto> activityList;

    @ApiModelProperty(value = "落地页url列表概率")
    private List<UrlRate> allUrlList;

    @ApiModelProperty(value = "安卓落地页url列表概率")
    private List<RateDto> urlList;

    @ApiModelProperty(value = "落地页url对应浮标")
    private List<Long> buoyIdList;

    @ApiModelProperty(value = "直投页列表")
    private List<RateDto> directPageList;

    @ApiModelProperty(value = "广告概率")
    private Integer advert;

    @ApiModelProperty(value = "广告直投时的定制浮标")
    private List<Long> advertBouyIds;

    private List<Long> advertBouyIdList;

    @ApiModelProperty(value = "广告ids")
    private List<Long> advertIds;

    @ApiModelProperty(value = "定向模式开关，0.不开启 1.开启")
    private Integer isDirectAdvert;

    @ApiModelProperty(value = "定向模式，1.仅投 2，优先投")
    private Integer  directModel;

    @ApiModelProperty(value = "广告位列表")
    private String advertsLocation;

    @ApiModelProperty(value = "配置项的id")
    private Long id;

    @ApiModelProperty(value = "配置项的标题")
    private String buoyTitle;

    @ApiModelProperty(value = "人群包")
    private String peopleTag;

    /** 广告的详细信息 */
    private List<RspAdvertDto> advertDetails;

    @ApiModelProperty(value = "插件概率")
    private Integer plugin;
    @ApiModelProperty(value = "插件ID和对应概率")
    private List<RateDto> pluginList;
    @ApiModelProperty(value = "落地页概率")
    private Integer landingPage;
    @ApiModelProperty(value = "落地页插件ID和对应概率")
    private List<RateDto> landingPagePluginList;
}
