package cn.com.duiba.tuia.pangea.center.api.rsp;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author scd
 * @version 1.0
 * @since 2019-09-06 10:31
 */
@Data
public class DayAppReportRsp implements Serializable {

    private static final long serialVersionUID = 380988989939784133L;

    /*共有部分*/

    private Long appId;//appId
    private String appName;//appName
    private Long slotId;//广告位id
    private String slotName;//广告位name
    private String curDateString;//日期

    private Long duizhao_actRequestPv;//活动请求PV
    private Long test1_actRequestPv;//活动请求PV
    private Long test2_actRequestPv;//活动请求PV
    private Long test3_actRequestPv;//活动请求PV
    private List<Long> actRequestPv;//活动请求PV组

    //塞值 先这样写着 等运行稳定了再删除荣誉字段
    public void setListValue() {
        setActRequestPv();
        setActRequestUv();
        setActJoinUv();
        setActJoinPv();
        setActParticipateRate();
        setRptParticipateCount();
        setAdvertRequestPv();
        setAdvertRequestCount();
        setAdvertSuccessRate();
        setAdvertShowCount();
        setRequestSuccessRate();
        setAdvertClickCount();
        setCtr();
        setAdConsumeExport();
        setActPerUvClickCount();
        setActPerUvLaunchCount();
        setActPerUvClickLaunchCount();
        setActPerUvConsume();
        setFormFeeClick();
        setFormLandPv();
        setFormAdvertCvr();
        setFormLandInnerPv();
        setCvr();
        setUvClickCvr();
        setActivityType();
        setActivityId();
        setActivityStatus();
        setLandChangePv();
        setActivitySource();
        setAdConsume();
    }

    private void setActRequestPv() {
        if (CollectionUtils.isEmpty(this.actRequestPv)) {
            actRequestPv = Lists.newArrayList();
        }
        actRequestPv.add(duizhao_actRequestPv);
        actRequestPv.add(test1_actRequestPv);
        actRequestPv.add(test2_actRequestPv);
        actRequestPv.add(test3_actRequestPv);
    }

    private Long duizhao_actRequestUv;//活动请求uv
    private Long test1_actRequestUv;//活动请求uv
    private Long test2_actRequestUv;//活动请求uv
    private Long test3_actRequestUv;//活动请求uv
    private List<Long> actRequestUv;//活动请求UV组

    private void setActRequestUv() {
        if (CollectionUtils.isEmpty(this.actRequestUv)) {
            actRequestUv = Lists.newArrayList();
        }
        actRequestUv.add(duizhao_actRequestUv);
        actRequestUv.add(test1_actRequestUv);
        actRequestUv.add(test2_actRequestUv);
        actRequestUv.add(test3_actRequestUv);
    }

    private Long duizhao_actJoinUv;//活动参与uv
    private Long test1_actJoinUv;//活动参与uv
    private Long test2_actJoinUv;//活动参与uv
    private Long test3_actJoinUv;//活动参与uv
    private List<Long> actJoinUv;//活动参与UV组

    private void setActJoinUv() {
        if (CollectionUtils.isEmpty(this.actJoinUv)) {
            actJoinUv = Lists.newArrayList();
        }
        actJoinUv.add(duizhao_actJoinUv);
        actJoinUv.add(test1_actJoinUv);
        actJoinUv.add(test2_actJoinUv);
        actJoinUv.add(test3_actJoinUv);
    }


    private Long duizhao_actJoinPv;//活动参与pv
    private Long test1_actJoinPv;//活动参与pv
    private Long test2_actJoinPv;//活动参与pv
    private Long test3_actJoinPv;//活动参与pv
    private List<Long> actJoinPv;//活动参与PV组

    private void setActJoinPv() {
        if (CollectionUtils.isEmpty(this.actJoinPv)) {
            actJoinPv = Lists.newArrayList();
        }
        actJoinPv.add(duizhao_actJoinPv);
        actJoinPv.add(test1_actJoinPv);
        actJoinPv.add(test2_actJoinPv);
        actJoinPv.add(test3_actJoinPv);
    }


    private Float duizhao_actParticipateRate;//参与率
    private Float test1_actParticipateRate;//参与率
    private Float test2_actParticipateRate;//参与率
    private Float test3_actParticipateRate;//参与率
    private List<Float> actParticipateRate;//参与率组

    private void setActParticipateRate() {
        if (CollectionUtils.isEmpty(this.actParticipateRate)) {
            actParticipateRate = Lists.newArrayList();
        }
        actParticipateRate.add(duizhao_actParticipateRate);
        actParticipateRate.add(test1_actParticipateRate);
        actParticipateRate.add(test2_actParticipateRate);
        actParticipateRate.add(test3_actParticipateRate);
    }

    private Float duizhao_rptParticipateCount;//'复参数'
    private Float test1_rptParticipateCount;//'复参数'
    private Float test2_rptParticipateCount;//'复参数'
    private Float test3_rptParticipateCount;//'复参数'
    private List<Float> rptParticipateCount;//复参数组

    private void setRptParticipateCount() {
        if (CollectionUtils.isEmpty(this.rptParticipateCount)) {
            rptParticipateCount = Lists.newArrayList();
        }
        rptParticipateCount.add(duizhao_rptParticipateCount);
        rptParticipateCount.add(test1_rptParticipateCount);
        rptParticipateCount.add(test2_rptParticipateCount);
        rptParticipateCount.add(test3_rptParticipateCount);
    }

    private Long duizhao_advertRequestPv;//券请求pv
    private Long test1_advertRequestPv;//券请求pv
    private Long test2_advertRequestPv;//券请求pv
    private Long test3_advertRequestPv;//券请求pv
    private List<Long> advertRequestPv;//券请求pv

    private void setAdvertRequestPv() {
        if (CollectionUtils.isEmpty(this.advertRequestPv)) {
            advertRequestPv = Lists.newArrayList();
        }
        advertRequestPv.add(duizhao_advertRequestPv);
        advertRequestPv.add(test1_advertRequestPv);
        advertRequestPv.add(test2_advertRequestPv);
        advertRequestPv.add(test3_advertRequestPv);
    }

    private Long duizhao_advertRequestCount;//发券量
    private Long test1_advertRequestCount;//发券量
    private Long test2_advertRequestCount;//发券量
    private Long test3_advertRequestCount;//发券量
    private List<Long> advertRequestCount;//发券量组

    private void setAdvertRequestCount() {
        if (CollectionUtils.isEmpty(this.advertRequestCount)) {
            advertRequestCount = Lists.newArrayList();
        }
        advertRequestCount.add(duizhao_advertRequestCount);
        advertRequestCount.add(test1_advertRequestCount);
        advertRequestCount.add(test2_advertRequestCount);
        advertRequestCount.add(test3_advertRequestCount);
    }

    private Float duizhao_advertSuccessRate;//发券成功率
    private Float test1_advertSuccessRate;//发券成功率
    private Float test2_advertSuccessRate;//发券成功率
    private Float test3_advertSuccessRate;//发券成功率
    private List<Float> advertSuccessRate;//发券成功率组

    private void setAdvertSuccessRate() {
        if (CollectionUtils.isEmpty(this.advertSuccessRate)) {
            advertSuccessRate = Lists.newArrayList();
        }
        advertSuccessRate.add(duizhao_advertSuccessRate);
        advertSuccessRate.add(test1_advertSuccessRate);
        advertSuccessRate.add(test2_advertSuccessRate);
        advertSuccessRate.add(test3_advertSuccessRate);
    }

    private Long duizhao_advertShowCount;//券曝光
    private Long test1_advertShowCount;//券曝光
    private Long test2_advertShowCount;//券曝光
    private Long test3_advertShowCount;//券曝光
    private List<Long> advertShowCount;//券曝光组

    private void setAdvertShowCount() {
        if (CollectionUtils.isEmpty(this.advertShowCount)) {
            advertShowCount = Lists.newArrayList();
        }
        advertShowCount.add(duizhao_advertShowCount);
        advertShowCount.add(test1_advertShowCount);
        advertShowCount.add(test2_advertShowCount);
        advertShowCount.add(test3_advertShowCount);
    }


    private Float duizhao_requestSuccessRate;//券曝光成功率
    private Float test1_requestSuccessRate;//券曝光成功率
    private Float test2_requestSuccessRate;//券曝光成功率
    private Float test3_requestSuccessRate;//券曝光成功率
    private List<Float> requestSuccessRate;//券曝光成功率组

    private void setRequestSuccessRate() {
        if (CollectionUtils.isEmpty(this.requestSuccessRate)) {
            requestSuccessRate = Lists.newArrayList();
        }
        requestSuccessRate.add(duizhao_requestSuccessRate);
        requestSuccessRate.add(test1_requestSuccessRate);
        requestSuccessRate.add(test2_requestSuccessRate);
        requestSuccessRate.add(test3_requestSuccessRate);
    }


    private Long duizhao_advertClickCount;//券有效点击
    private Long test1_advertClickCount;//券有效点击
    private Long test2_advertClickCount;//券有效点击
    private Long test3_advertClickCount;//券有效点击
    private List<Long> advertClickCount;//券有效点击组

    private void setAdvertClickCount() {
        if (CollectionUtils.isEmpty(this.advertClickCount)) {
            advertClickCount = Lists.newArrayList();
        }
        advertClickCount.add(duizhao_advertClickCount);
        advertClickCount.add(test1_advertClickCount);
        advertClickCount.add(test2_advertClickCount);
        advertClickCount.add(test3_advertClickCount);
    }

    private Float duizhao_ctr;//ctr
    private Float test1_ctr;//ctr
    private Float test2_ctr;//ctr
    private Float test3_ctr;//ctr
    private List<Float> ctr;//ctr组

    private void setCtr() {
        if (CollectionUtils.isEmpty(this.ctr)) {
            ctr = Lists.newArrayList();
        }
        ctr.add(duizhao_ctr);
        ctr.add(test1_ctr);
        ctr.add(test2_ctr);
        ctr.add(test3_ctr);
    }

    private Float duizhao_adConsume_export;//消耗
    private Float test1_adConsume_export;//消耗
    private Float test2_adConsume_export;//消耗
    private Float test3_adConsume_export;//消耗
    private List<Float> adConsume_export;//消耗组

    private void setAdConsumeExport() {
        if (CollectionUtils.isEmpty(this.adConsume_export)) {
            adConsume_export = Lists.newArrayList();
        }
        adConsume_export.add(duizhao_adConsume_export);
        adConsume_export.add(test1_adConsume_export);
        adConsume_export.add(test2_adConsume_export);
        adConsume_export.add(test3_adConsume_export);
    }


    private Float duizhao_actPerUvClickCount;//每uv参与
    private Float test1_actPerUvClickCount;//每uv参与
    private Float test2_actPerUvClickCount;//每uv参与
    private Float test3_actPerUvClickCount;//每uv参与
    private List<Float> actPerUvClickCount;//每uv参与组

    private void setActPerUvClickCount() {
        if (CollectionUtils.isEmpty(this.actPerUvClickCount)) {
            actPerUvClickCount = Lists.newArrayList();
        }
        actPerUvClickCount.add(duizhao_actPerUvClickCount);
        actPerUvClickCount.add(test1_actPerUvClickCount);
        actPerUvClickCount.add(test2_actPerUvClickCount);
        actPerUvClickCount.add(test3_actPerUvClickCount);
    }


    private Float duizhao_actPerUvLaunchCount;//每uv发券
    private Float test1_actPerUvLaunchCount;//每uv发券
    private Float test2_actPerUvLaunchCount;//每uv发券
    private Float test3_actPerUvLaunchCount;//每uv发券
    private List<Float> actPerUvLaunchCount;//每uv发券组

    private void setActPerUvLaunchCount() {
        if (CollectionUtils.isEmpty(this.actPerUvLaunchCount)) {
            actPerUvLaunchCount = Lists.newArrayList();
        }
        actPerUvLaunchCount.add(duizhao_actPerUvLaunchCount);
        actPerUvLaunchCount.add(test1_actPerUvLaunchCount);
        actPerUvLaunchCount.add(test2_actPerUvLaunchCount);
        actPerUvLaunchCount.add(test3_actPerUvLaunchCount);
    }


    private Float duizhao_actPerUvClickLaunchCount;//每uv券点击
    private Float test1_actPerUvClickLaunchCount;//每uv券点击
    private Float test2_actPerUvClickLaunchCount;//每uv券点击
    private Float test3_actPerUvClickLaunchCount;//每uv券点击
    private List<Float> actPerUvClickLaunchCount; //每uv券点击组

    private void setActPerUvClickLaunchCount() {
        if (CollectionUtils.isEmpty(this.actPerUvClickLaunchCount)) {
            actPerUvClickLaunchCount = Lists.newArrayList();
        }
        actPerUvClickLaunchCount.add(duizhao_actPerUvClickLaunchCount);
        actPerUvClickLaunchCount.add(test1_actPerUvClickLaunchCount);
        actPerUvClickLaunchCount.add(test2_actPerUvClickLaunchCount);
        actPerUvClickLaunchCount.add(test3_actPerUvClickLaunchCount);
    }


    private Float duizhao_actPerUvConsume;//每uv收益
    private Float test1_actPerUvConsume;//每uv收益
    private Float test2_actPerUvConsume;//每uv收益
    private Float test3_actPerUvConsume;//每uv收益
    private List<Float> actPerUvConsume; //每uv收益组

    private void setActPerUvConsume() {
        if (CollectionUtils.isEmpty(this.actPerUvConsume)) {
            actPerUvConsume = Lists.newArrayList();
        }
        actPerUvConsume.add(duizhao_actPerUvConsume);
        actPerUvConsume.add(test1_actPerUvConsume);
        actPerUvConsume.add(test2_actPerUvConsume);
        actPerUvConsume.add(test3_actPerUvConsume);
    }


    private Long duizhao_formFeeClick;//表单类计费点击
    private Long test1_formFeeClick;//表单类计费点击
    private Long test2_formFeeClick;//表单类计费点击
    private Long test3_formFeeClick;//表单类计费点击
    private List<Long> formFeeClick;//表单类计费点击组

    private void setFormFeeClick() {
        if (CollectionUtils.isEmpty(this.formFeeClick)) {
            formFeeClick = Lists.newArrayList();
        }
        formFeeClick.add(duizhao_formFeeClick);
        formFeeClick.add(test1_formFeeClick);
        formFeeClick.add(test2_formFeeClick);
        formFeeClick.add(test3_formFeeClick);
    }


    private Long duizhao_formLandPv;//表单类落地页访问PV
    private Long test1_formLandPv;//表单类落地页访问PV
    private Long test2_formLandPv;//表单类落地页访问PV
    private Long test3_formLandPv;//表单类落地页访问PV
    private List<Long> formLandPv;//表单类落地页访问PV组

    private void setFormLandPv() {
        if (CollectionUtils.isEmpty(this.formLandPv)) {
            formLandPv = Lists.newArrayList();
        }
        formLandPv.add(duizhao_formLandPv);
        formLandPv.add(test1_formLandPv);
        formLandPv.add(test2_formLandPv);
        formLandPv.add(test3_formLandPv);
    }


    private Float duizhao_formAdvertCvr;//表单类广告CvR
    private Float test1_formAdvertCvr;//表单类广告CvR
    private Float test2_formAdvertCvr;//表单类广告CvR
    private Float test3_formAdvertCvr;//表单类广告CvR
    private List<Float> formAdvertCvr;//表单类广告CvR组

    private void setFormAdvertCvr() {
        if (CollectionUtils.isEmpty(this.formAdvertCvr)) {
            formAdvertCvr = Lists.newArrayList();
        }
        formAdvertCvr.add(duizhao_formAdvertCvr);
        formAdvertCvr.add(test1_formAdvertCvr);
        formAdvertCvr.add(test2_formAdvertCvr);
        formAdvertCvr.add(test3_formAdvertCvr);
    }


    private Long duizhao_formLandInnerPv;//表单类落地页转化PV
    private Long test1_formLandInnerPv;//表单类落地页转化PV
    private Long test2_formLandInnerPv;//表单类落地页转化PV
    private Long test3_formLandInnerPv;//表单类落地页转化PV
    private List<Long> formLandInnerPv;//表单类落地页转化PV组

    private void setFormLandInnerPv() {
        if (CollectionUtils.isEmpty(this.formLandInnerPv)) {
            formLandInnerPv = Lists.newArrayList();
        }
        formLandInnerPv.add(duizhao_formLandInnerPv);
        formLandInnerPv.add(test1_formLandInnerPv);
        formLandInnerPv.add(test2_formLandInnerPv);
        formLandInnerPv.add(test3_formLandInnerPv);
    }

    private Float duizhao_cvr;//cvr
    private Float test1_cvr;//cvr
    private Float test2_cvr;//cvr
    private Float test3_cvr;//cvr
    private List<Float> cvr;//CvR组

    private void setCvr() {
        if (CollectionUtils.isEmpty(this.cvr)) {
            cvr = Lists.newArrayList();
        }
        cvr.add(duizhao_cvr);
        cvr.add(test1_cvr);
        cvr.add(test2_cvr);
        cvr.add(test3_cvr);
    }

    private Float duizhao_uvClickCvr;//每uv点券CVR
    private Float test1_uvClickCvr;//每uv点券CVR
    private Float test2_uvClickCvr;//每uv点券CVR
    private Float test3_uvClickCvr;//每uv点券CVR
    private List<Float> uvClickCvr;//每uv点券CVR组

    private void setUvClickCvr() {
        if (CollectionUtils.isEmpty(this.uvClickCvr)) {
            uvClickCvr = Lists.newArrayList();
        }
        uvClickCvr.add(duizhao_uvClickCvr);
        uvClickCvr.add(test1_uvClickCvr);
        uvClickCvr.add(test2_uvClickCvr);
        uvClickCvr.add(test3_uvClickCvr);
    }

    //数据模块
    private Integer duizhao_activityType;//类型
    private Integer test1_activityType;//类型
    private Integer test2_activityType;//类型
    private Integer test3_activityType;//类型
    private List<Integer> activityType;//类型组

    private void setActivityType() {
        if (CollectionUtils.isEmpty(this.activityType)) {
            activityType = Lists.newArrayList();
        }
        activityType.add(duizhao_activityType);
        activityType.add(test1_activityType);
        activityType.add(test2_activityType);
        activityType.add(test3_activityType);
    }

    private Long duizhao_activityId; //活动id
    private Long test1_activityId; //活动id
    private Long test2_activityId; //活动id
    private Long test3_activityId; //活动id
    private List<Long> activityId;//活动组

    private void setActivityId() {
        if (CollectionUtils.isEmpty(this.activityId)) {
            activityId = Lists.newArrayList();
        }
        activityId.add(duizhao_activityId);
        activityId.add(test1_activityId);
        activityId.add(test2_activityId);
        activityId.add(test3_activityId);
    }


    private Integer duizhao_activityStatus;//状态
    private Integer test1_activityStatus;//状态
    private Integer test2_activityStatus;//状态
    private Integer test3_activityStatus;//状态
    private List<Integer> activityStatus;//状态组

    private void setActivityStatus() {
        if (CollectionUtils.isEmpty(this.activityStatus)) {
            activityStatus = Lists.newArrayList();
        }
        activityStatus.add(duizhao_activityStatus);
        activityStatus.add(test1_activityStatus);
        activityStatus.add(test2_activityStatus);
        activityStatus.add(test3_activityStatus);
    }


    private Long duizhao_landChangePv;
    private Long test1_landChangePv;
    private Long test2_landChangePv;
    private Long test3_landChangePv;
    private List<Long> landChangePv;

    private void setLandChangePv() {
        if (CollectionUtils.isEmpty(this.landChangePv)) {
            landChangePv = Lists.newArrayList();
        }
        landChangePv.add(duizhao_landChangePv);
        landChangePv.add(test1_landChangePv);
        landChangePv.add(test2_landChangePv);
        landChangePv.add(test3_landChangePv);
    }


    private Long test1_activitySource;//活动对应对照id
    private Long test2_activitySource;//活动对应对照id
    private Long test3_activitySource;//活动对应对照id
    private List<Long> activitySource;//活动对应对照id

    private void setActivitySource() {
        if (CollectionUtils.isEmpty(this.activitySource)) {
            activitySource = Lists.newArrayList();
        }
        activitySource.add(0L);
        activitySource.add(test1_activitySource);
        activitySource.add(test2_activitySource);
        activitySource.add(test3_activitySource);
    }


    private Long duizhao_adConsume;//消耗
    private Long test1_adConsume;//消耗
    private Long test2_adConsume;//消耗
    private Long test3_adConsume;//消耗
    private List<Long> adConsume;//消耗组

    private void setAdConsume() {
        if (CollectionUtils.isEmpty(this.adConsume)) {
            adConsume = Lists.newArrayList();
        }
        adConsume.add(duizhao_adConsume);
        adConsume.add(test1_adConsume);
        adConsume.add(test2_adConsume);
        adConsume.add(test3_adConsume);
    }


    private Integer slotStatus;


    /*--------------------------以上是原数据，下面是计算数据-----------------*/
    private Boolean showButton;//显示按钮
    //测试组1
    private Boolean test1_showButton;//显示按钮
    //测试组2
    private Boolean test2_showButton;//显示按钮
    //测试组3
    private Boolean test3_showButton;//显示按钮

    private String curDate;
    private Integer testCount;//测试组数量
    private String mediaName;//媒体运营名字
    private Long mediaId;//媒体id


    public Long getDuizhao_actRequestPv() {
        if (duizhao_actRequestPv == null) {
            return 0L;
        }
        return duizhao_actRequestPv;
    }

    public void setDuizhao_actRequestPv(final Long duizhao_actRequestPv) {
        this.duizhao_actRequestPv = duizhao_actRequestPv;
    }

    public Long getDuizhao_actRequestUv() {
        if (duizhao_actRequestUv == null) {
            return 0L;
        } else {
            return duizhao_actRequestUv;
        }

    }

    public void setDuizhao_actRequestUv(final Long duizhao_actRequestUv) {
        this.duizhao_actRequestUv = duizhao_actRequestUv;
    }

    public Long getDuizhao_actJoinUv() {
        if (duizhao_actJoinUv == null) {
            return 0L;
        }
        return duizhao_actJoinUv;
    }

    public void setDuizhao_actJoinUv(final Long duizhao_actJoinUv) {
        this.duizhao_actJoinUv = duizhao_actJoinUv;
    }

    public Long getDuizhao_actJoinPv() {
        if (duizhao_actJoinPv == null) {
            return 0L;
        }
        return duizhao_actJoinPv;
    }

    public void setDuizhao_actJoinPv(final Long duizhao_actJoinPv) {
        this.duizhao_actJoinPv = duizhao_actJoinPv;
    }

    public Long getDuizhao_advertRequestPv() {
        if (duizhao_advertRequestPv == null) {
            return 0L;
        }
        return duizhao_advertRequestPv;
    }

    public void setDuizhao_advertRequestPv(final Long duizhao_advertRequestPv) {
        this.duizhao_advertRequestPv = duizhao_advertRequestPv;
    }

    public Long getDuizhao_advertRequestCount() {
        if (duizhao_advertRequestCount == null) {
            return 0L;
        }
        return duizhao_advertRequestCount;
    }

    public void setDuizhao_advertRequestCount(final Long duizhao_advertRequestCount) {
        this.duizhao_advertRequestCount = duizhao_advertRequestCount;
    }

    public Long getDuizhao_advertShowCount() {
        if (duizhao_advertShowCount == null) {
            return 0L;
        }
        return duizhao_advertShowCount;
    }

    public void setDuizhao_advertShowCount(final Long duizhao_advertShowCount) {
        this.duizhao_advertShowCount = duizhao_advertShowCount;
    }

    public Long getDuizhao_advertClickCount() {
        if (duizhao_advertClickCount == null) {
            return 0L;
        }
        return duizhao_advertClickCount;
    }

    public void setDuizhao_advertClickCount(final Long duizhao_advertClickCount) {
        this.duizhao_advertClickCount = duizhao_advertClickCount;
    }

    public Long getDuizhao_adConsume() {
        if (duizhao_adConsume == null) {
            return 0L;
        }
        return duizhao_adConsume;
    }

    public void setDuizhao_adConsume(final Long duizhao_adConsume) {
        this.duizhao_adConsume = duizhao_adConsume;
    }

    public Long getDuizhao_formFeeClick() {
        if (duizhao_formFeeClick == null) {
            return 0L;
        }
        return duizhao_formFeeClick;
    }

    public void setDuizhao_formFeeClick(final Long duizhao_formFeeClick) {
        this.duizhao_formFeeClick = duizhao_formFeeClick;
    }

    public Long getDuizhao_formLandPv() {
        if (duizhao_formLandPv == null) {
            return 0L;
        }
        return duizhao_formLandPv;
    }

    public void setDuizhao_formLandPv(final Long duizhao_formLandPv) {
        this.duizhao_formLandPv = duizhao_formLandPv;
    }

    public Long getDuizhao_formLandInnerPv() {
        if (duizhao_formLandInnerPv == null) {
            return 0L;
        }
        return duizhao_formLandInnerPv;
    }

    public void setDuizhao_formLandInnerPv(final Long duizhao_formLandInnerPv) {
        this.duizhao_formLandInnerPv = duizhao_formLandInnerPv;
    }

    public Long getDuizhao_landChangePv() {
        if (duizhao_landChangePv == null) {
            return 0L;
        }
        return duizhao_landChangePv;
    }

    public void setDuizhao_landChangePv(final Long duizhao_landChangePv) {
        this.duizhao_landChangePv = duizhao_landChangePv;
    }

}
