package cn.com.duiba.tuia.pangea.center.api.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=false)
public class ReqReportByPage extends BaseQueryReq{

    private List<Long> testActivityId;

    private Long duizhaoActivityId;

    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String startTime;

    /** The end date. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String endTime;

    private Long planId;

    private Long slotId;

    private Integer exportType;

    private String creator;

    private Integer activityType;

    private List<Long> activityIds;

    public Integer getExportType() {
        return exportType;
    }

    private Long activitySource;

    private Integer selectType;

    private Long testOneId;

    public void setExportType(final Integer exportType) {
        this.exportType = exportType;
    }
}
