package cn.com.duiba.tuia.pangea.center.api.dto.apollo;

import cn.com.duiba.tuia.pangea.center.api.constant.ApolloKeyConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿波罗盘古key-value
 * ApolloKeyEnum
 *
 * @author wangzhanjin
 * @email
 * @date 2020-07-21 14:46:33
 */
@Data
public class ApolloKeyValueDTO implements Serializable {
    private static final long serialVersionUID = 5510803986440442281L;

    /**
     * keyValueJson中的key和value
     * [{ids:'70001,70002',v:'20'},{ids:'7004', v:'30'}]
     */
    public static String VALUE_JSON_IDS = "ids";
    public static String VALUE_JSON_VALUE = "value";

    /**
     * id列表的分隔符
     */
    public static String SPLIT_STR = ",";

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "不可修改：0为专项定制，其他需要列表处理json校验：1为媒体，2为广告位，3为活动，4皮肤，5广告（待定）", required = true)
    private Integer keyType;

    @ApiModelProperty(value = "相关研发人员adminId：逗号分割", required = true)
    private String ownerNames;

    @ApiModelProperty(value = "配置key名称", required = true)
    private String keyName;

    @ApiModelProperty(value = "配置的描述，使用方法", required = true)
    private String keyDesc;

    @ApiModelProperty(value = "配置的cf链接", required = true)
    private String keyCfUrl;

    @ApiModelProperty(value = "不可修改：配置key的关键字，唯一", required = true)
    private String keyStr;

    @ApiModelProperty(value = "配置key对应的value值，type>0都是json数组，举例：[{ids:'70001,70002',v:'20'},{ids:'7004', v:'30'}]")
    private String keyValueJson;
    private String keyIdMapStr;

    /**
     * {@link ApolloKeyConstant}
     */
    @ApiModelProperty(value = "当前配置的开关，默认1开，0关")
    private Integer keyOnOff;

    /**
     * {@link ApolloKeyConstant}
     */
    @ApiModelProperty(value = "默认1，白名单1，黑名单2", required = true)
    private Integer whiteBlack;

    @ApiModelProperty(value = "当前创建人的信息")
    private String adminId;

    @ApiModelProperty(value = "下线时间，待定")
    private Date offlineTime;

    @ApiModelProperty(value = "创建时间")
    private Date gmtCreate;

    @ApiModelProperty(value = "修改时间，强删表，有历史表")
    private Date gmtModified;

    /**
     * 区分不同环境配置：仅限dev、test、pre、prod，默认为null
     * 无需前端传值，后端判断
     */
    private String sysEnv;

    /**
     * {@link ApolloKeyConstant}
     */
    @ApiModelProperty(value = "Apollo配置页面功能优化需求新增字段，是否拥有修改权限，1：开，0：关", example = "1", required = true)
    private Integer updateAuthority;
}
