package cn.com.duiba.tuia.pangea.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.apollo.ApolloKeyValueHistoryDTO;

import java.util.List;

/**
 * 阿波罗盘古key-value，历史表
 *
 * @author wangzhanjin
 * @email
 * @date 2020-07-21 14:46:33
 */
@AdvancedFeignClient
public interface RemoteApolloKeyValueHistoryService {

    /**
     * 插入ApolloKeyValueHistory到数据库,包括null值
     *
     * @param dto
     * @return
     */
    int insertApolloKeyValueHistory(ApolloKeyValueHistoryDTO dto);

    /**
     * 根据阿波罗的key的主键查询 历史修改记录
     * @param keyId
     * @return
     */
    List<ApolloKeyValueHistoryDTO> getModifyHistories(Long keyId);
}
