package cn.com.duiba.tuia.pangea.center.api.req.resource;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 *
 * @author miaohongshuai
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ResourceFlowTestReq implements Serializable {

    private static final long serialVersionUID = -6058224231052307868L;
    /**
     * 测试计划ID
     */
    private Long planId;
    /**
     * 活动ID列表
     */
    private List<Long> activityIds;
    /**
     * 测试类型列表，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
     */
    private List<Integer> testTypes;
    /**
     * 广告位ID列表
     */
    private List<Long> slotIds;

    /**
     * 全部切量还是部分切量
     */
    private Integer flowType;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 查询的测试状态列表
     */
    private List<Integer> testStatusList;
}
