package cn.com.duiba.tuia.pangea.center.api.constant;

import cn.com.duiba.tuia.pangea.center.api.dto.apollo.ApolloKeyValueDTO;

/**
 * apolloKey的类型 {@link ApolloKeyValueDTO} keyType, ownerNames
 * 0为专项定制，
 * 其他需要列表处理json校验：
 * 1为媒体，2为广告位，3为活动，4皮肤，5广告（待定）
 */
public enum ApolloKeyEnum {

    SPECIAL(0, "专项定制"),
    APP(1, "媒体"),
    SLOT(2, "广告位"),
    ACTIVITY(3, "活动"),
    SKIN(4, "皮肤"),
    ADVERT(5, "广告（待定）"),
    SLOT_MATERIAL(6, "广告位素材"),
    MAP(7, "map类型")
    ;

    ApolloKeyEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 是否需要定制处理id和列表
     * 目前只有keyType=0，定制化场景不需要
     * @param code
     * @return
     */
    public static Boolean needCheckJsonFlag(Integer code) {
        if (null == code || SPECIAL.getCode().equals(code) || MAP.getCode().equals(code)) {
            return false;
        }
        return true;

    }

    /**
     * 合法的type类型
     *
     * @param code
     * @return
     */
    public static Boolean legalTypeFlag(Integer code) {
        if (null == code || code < 0 || code > 6) {
            return false;
        }
        return true;
    }
}
